C     DynDom3D IS A PROGRAM TO DETERMINE DYNAMIC DOMAINS AND HINGE AXES FOR A PAIR OF
C     BIOMOLECULAR CONFORMATIONAL STATES. THIS PROGRAM IS AN EXTENSION OF EXISTING PROGRAM
C     DynDom1.5.
C
c     DynDom3D  IS APPLICABLE FOR PROTEINS AND PROTEIN NUCLEIC ACID COMPLEXES.
C     FOR MORE INFORMATION REGARDING USAGE AND DOWNLOADING THE PROGRAM
C     PLEASE VISIT: http://www.cmp.uea.ac.uk/dyndom/3D
C     FOR MORE INFORMATION REGARDING THE METHODOLOGY PLEASE REFER
C
C       "Systematic Analysis of Domain Motions in Proteins from Conformational Change: 
C        New Results on Citrate Synthase and T4 Lysozyme."
c       "Proteins, Vol 30 144-154,1998"
C
C          AND IN PARTICULAR:
C
C        "A  method for the analysis of domain movements in large biomolecular complexes"
C         by Guru Prasad Poornam, Atsushi Matsumoto, Hisashi Ishida, Steven Hayward, Proteins, In Press
C
      PROGRAM DynDom3D 
      IMPLICIT NONE
      INCLUDE 'DynDom.param'
C 
      INTEGER NCLUSTER,ITER,DOMIN,BLKSIZE,IDOM
      INTEGER NATOT1,NATOT2,I,NPAIR,MODAT1(0:NUMATMX),MODAT2(0:NUMATMX)
      INTEGER CHCOUNT1,CHCOUNT2,ND(NDOMX),IAT
      INTEGER ATCLUS(NUMATMX)
      INTEGER IWIND,RESMAX1,RESMAX2
      INTEGER MM,NDIM,NDOM
      INTEGER DMSUM1,DMSUM2,IWORK(NBLOCKMX)
      INTEGER NCON(NDOMX),ATDROPNUM(NUMATMX),ATDOMM(NUMATMX)
      INTEGER INCLUS(NUMATMX,NCLUSMX),CLUSCOUNT(NUMATMX)
      INTEGER DOMAT(NDOMX),DOMATOM(NDOMX,NUMATMX)
      INTEGER DOMCON(NDOMX,NDOMX),DOMSIZE(NDOMX)
      INTEGER DOMCONAT(NDOMX,NUMATMX),NCONAT(NDOMX)
      INTEGER IGRID1(0:NGRIDMX,0:NGRIDMX,
     &        0:NGRIDMX)      
      INTEGER IGRIDAT1(0:NGRIDMX,0:NGRIDMX,
     &        0:NGRIDMX,2*GRDATMX)      
      INTEGER BLKIND(0:NGRIDMX,0:NGRIDMX,
     &        0:NGRIDMX)     
      INTEGER GCOO1(3,NUMATMX),GRDATMAX
      INTEGER ATBL(NUMATMX),ATBLK(NUMATMX,500)
      INTEGER GMIN1(3),GMAX1(3),NBLOCK
      INTEGER NDOMO,TBLOCK
      INTEGER IN1,IN2,IOUT1,IOUT7,IOUT4,IOUT6     
      INTEGER DOMORD(NDOMX)
      INTEGER CLUSATOM(NCLUSMX,NUMATMX),CLUSAT(NCLUSMX)
      REAL*8 CMIN1(3),CMAX1(3),COM1(3),GRDSIZE
      REAL*8 EXTCRIT,AMPTHETAV,SCALE,COSHIFT1(3)
      REAL*8 COO1(3,NUMATMX),COO2(3,NUMATMX)
      REAL*8 CO1(3,NUMATMX)
      REAL*8 MASS(NUMATMX),RMSD,PEROCC
      REAL*8 WORK(NARB),SUM(7,3,NDOMX)
      REAL*8 AMPTHET(NBLOCKMX)
      REAL*8 ROT(NBLOCKMX,3)
      REAL*8 EXTINT(NDOMX,NDOMX)
      REAL*8 PACO1(3,NUMATMX)
      CHARACTER*4 ATYP1(NUMATMX),ATYP2(NUMATMX)
      CHARACTER*4 RESTYP1(NUMATMX),RESTYP2(NUMATMX)
      CHARACTER*5 RESNUM1(NUMATMX),RESNUM2(NUMATMX)
      CHARACTER*1 ATCHAIN1(NUMATMX),ATCHAIN2(NUMATMX)
      CHARACTER*200 FILEIN1,FILEIN2
      LOGICAL LCONAT(NUMATMX),CLUSOK,LCHAINID,nullres  
C
C===========================
C INITIALISATION
C===========================
       MODAT1(0)=0
       MODAT2(0)=0
       DO 2828 I=1,NUMATMX
        MASS(I)=1.0D0
        LCONAT(I)=.FALSE.
        MODAT1(I)=0
        MODAT2(I)=0
2828   CONTINUE	  
       DO IDOM=1,NDOMX
        DOMAT(IDOM)=0
        DO IAT=1,NUMATMX
         DOMATOM(IDOM,IAT)=0
        END DO
       END DO   

C=====================================================================
C GETTING THE INPUT VARIABLES FROM THE COMMAND FILE
C=====================================================================      
        CALL INOUTPUTR(IN1,IN2,IOUT1,IOUT4,IOUT6,IOUT7,NCLUSTER,
     &                 ITER,GRDSIZE,BLKSIZE,PEROCC,DOMIN,EXTCRIT,
     &                 FILEIN1,FILEIN2)
        
C=============================================================
C OPENING THE INPUT FILES
C=============================================================
       OPEN (IN1,FILE=FILEIN1,STATUS='OLD',FORM='FORMATTED')
C=============================================================
C OPENING THE OUTPUT FILES
C=============================================================
             
         IF(FILEIN1.NE.FILEIN2) THEN  
          OPEN(IN2,FILE=FILEIN2,STATUS='OLD',FORM='FORMATTED')
         ELSE
          IN2=IN1
         ENDIF   
C==============================================================               
C READING FIRST PDB FILE
C=====================================================
       
       CALL READPDB(IN1,NATOT1,ATCHAIN1,ATYP1,RESTYP1,
     &            RESNUM1,COO1,CHCOUNT1,LCHAINID,MODAT1,RESMAX1)

         IF(NATOT1.EQ.0) THEN
          WRITE(6,*)'NO ATOMS FOUND IN FILE ',FILEIN1
          STOP
         ENDIF
C=====================================================
C READING SECOND PDB FILE
C=====================================================
       CALL READPDB(IN2,NATOT2,ATCHAIN2,ATYP2,RESTYP2,
     &  RESNUM2,COO2,CHCOUNT2,LCHAINID,MODAT2,RESMAX2)        
C=====================================================
C CHECK FOR EQUALITY OF ATOMS
C=====================================================  
       IF(NATOT2.EQ.0) THEN
        WRITE(6,*)'NO ATOMS FOUND IN FILE ',FILEIN2
        STOP
       ENDIF
       
       IF(NATOT1.NE.NATOT2) THEN
         WRITE(6,*)'WARNING: NO OF ATOMS DIFFERENT'
         WRITE(6,*)'ATOMS IN CONFORMER1: ',NATOT1,' CONFORMER2: ',NATOT2
         WRITE(6,*)'PLEASE CHECK YOUR INPUT ATOMS '
         WRITE(6,*)'RESULTS MAY NOT BE CORRECT '
         STOP
       END IF 	

       IF (CHCOUNT1 .NE. CHCOUNT2) THEN
         WRITE(6,*)'WARNING: UNEQUAL NUMBER OF CHAINS: ',CHCOUNT1,
     &' & ',CHCOUNT2,' IN ',FILEIN1,' & ',FILEIN2,' RESPECTIVELY',
     &' RESULTS MAY NOT BE CORRECT '
c WRITE(6,*)'PLEASE CHECK YOUR INPUT PDB FILES' 
c STOP
       ENDIF
C==========================================================      
C  ORIENT THE  FIRST CONFORMATION TOWARDS ITS' PRINCIPAL AXIS
c--------------------------------------------------------------     
       CALL PRINAX(NATOT1,COO1,PACO1)
C================================================================
C=====CALCULATING CENTRE OF MASS AND TRANSLATE THE COORDINATE OF 
C     CONFORMATION ONE TO THE POSITIVE  FRAME
C=================================================================
      CALL CMASS(NATOT1,PACO1,COM1,CMIN1,CMAX1,CO1,COSHIFT1)
C==========================================================
C NOW CALL THE GRID ROUTINE FOR A GRID INDEX

      CALL GRID(NATOT1,CMIN1,CMAX1,CO1,GRDSIZE,GCOO1,IGRID1,IGRIDAT1,
     &          GMIN1,GMAX1,GRDATMAX)    
C======================================================
C START OFF WITH WHOLE PROTEIN AS A DOMAIN
         NDOM=1
         IDOM=1
         DOMAT(IDOM)=NATOT1
	 
      DO IAT=1,NATOT1
         DOMATOM(IDOM,IAT)=IAT
      END DO      
C===========================================================
C  CALCULATE THE ROTATION VECTOR FOR BLOCKS     

      CALL ROTVECFIT(NATOT1,IDOM,DOMAT,DOMATOM,GRDSIZE,
     &               BLKSIZE,PEROCC,CO1,COO2,IGRID1,
     &               IGRIDAT1,GMIN1,GMAX1,GRDATMAX,ATBL,
     &               ATBLK,BLKIND,NBLOCK,ROT,AMPTHET,AMPTHETAV,MASS,
     &               RMSD,TBLOCK) 
C==================================================================
C
C==================================================================
C CALL THE CLUSTERING ROUTINE FOR CLUSTERING THE ROTATION VECTORS
C=================================================================
         DMSUM1=7
         DMSUM2=3
         MM=NBLOCKMX 
         NDIM =3

      CALL CLUSTER2_1(MM,NBLOCK,NDIM,ROT,NCLUSTER,ITER,DMSUM1,DMSUM2,
     &              SUM,IWORK,WORK,NDOM,DOMIN,NATOT1,LCHAINID,
     &              GRDSIZE,BLKSIZE,
     &              ATBL,ATBLK,ATCLUS,INCLUS,CLUSCOUNT,BLKIND,CO1,COO2
     &              ,GCOO1,IGRID1,IGRIDAT1,GMAX1,
     &              MASS,DOMSIZE,DOMAT,DOMATOM,NDOMO,NCON,
     &              DOMCON,DOMCONAT,NCONAT,ND,
     &              DOMORD,EXTCRIT,EXTINT,LCONAT,ATDROPNUM,ATDOMM,
     &              CLUSAT,CLUSATOM,CLUSOK,nullres)
		if(nullres) then
       
                  SCALE=40/(AMPTHETAV)
	   
                  Do  IWIND = 1,NBLOCK 
                 WRITE(IOUT4,2002)'ATOM',IWIND,'CA  ','GLY ','A',IWIND,
     &             ROT(IWIND,1)*SCALE,ROT(IWIND,2)*SCALE,
     &             ROT(IWIND,3)*SCALE
                  END DO
C       
                  WRITE(IOUT4,'(A)')'END'		
                  WRITE(6,*)'NO RESULT. TRY CHANGING THE PARAMETERS'
		  goto 999
		endif
		
C====================================================================
c        IF (.NOT. CLUSOK ) THEN
c	   WRITE(6,*)' STOPPING AFTER CLUSTERING WITH NO OUTPUT '
c	   STOP 
c	END IF
c====================================================================	
c WRITING OUT the info file
c==========================================================================
        WRITE (IOUT1,'(A,I8)')'NUMBER OF ATOMS IN BOTH CONFORMATIONS :  
     &',NATOT1
              WRITE (IOUT1,'(A80)') '===================================
     &=============================================' 

        WRITE(IOUT1,'(A)')'DynDom3D OUTPUT :'      
        WRITE(IOUT1,'(A)')'	'
        WRITE (IOUT1,'(A57,I6)')'TOTAL BLOCKS INCLUDED FOR CALCULATING 
     &ROTATION VECTOR : ',TBLOCK
        WRITE (IOUT1,'(A,I2)')'NUMBER OF DYNAMIC DOMAINS : ',NDOM
              WRITE (IOUT1,'(A80)') '===================================
     &============================================='        
C====================================================================
C WRITING OUT THE ROTATION VECTOR: SCALING IS FOR DISPLAY IN RASMOL
C COLOURING ACCRDING TO THE BLOCKS NOTE : COLOUR VALUE IS PRINTED IN 
C B-FACTOR COLUMN.
C=================================================================
       
           SCALE=40/(AMPTHETAV)
	   
       Do  IWIND = 1,NBLOCK 
           WRITE(IOUT4,2002)'ATOM',IWIND,'CA  ','GLY ','A',IWIND,
     &           ROT(IWIND,1)*SCALE,ROT(IWIND,2)*SCALE,
     &           ROT(IWIND,3)*SCALE,IWORK(IWIND)+1
       END DO
C       
       WRITE(IOUT4,'(A)')'END'
C==============================================================
C WRITING OUT THE PDB FILE with colouring of ATDOMM
C=============================================================
       DO IAT=1,NATOT1 
C       

         IF (IAT .GT.1) THEN
	  IF (ATCHAIN1(IAT) .NE. ATCHAIN1(IAT-1)) THEN
             WRITE(IOUT6,2006)'TER'
	   END IF  
         END IF

       IF (MODAT1(IAT) .NE. 0 .AND. MODAT1(IAT) .NE. MODAT1(IAT-1)) THEN
        IF(IAT .EQ. 1) THEN
c            WRITE(IOUT6,2010)'MODEL ',MODAT1(IAT)
        ELSE IF (IAT .NE. 1 .AND. ATCHAIN1(IAT).EQ.ATCHAIN1(IAT-1)) THEN
             WRITE(IOUT6,2006)'TER'
c            WRITE(IOUT6,2010)'MODEL ',MODAT1(IAT)
        END IF
       END IF
C	 
        IF (ATDOMM(IAT) .EQ. 0) THEN
         WRITE(IOUT6,2003)'ATOM',IAT-1,ATYP1(IAT),RESTYP1(IAT),
     &   ATCHAIN1(IAT),RESNUM1(IAT),COO1(1,IAT),COO1(2,IAT),
     &   COO1(3,IAT),0 
cC     
        ELSE
cC	
          WRITE(IOUT6,2003)'ATOM',IAT-1,ATYP1(IAT),RESTYP1(IAT),
     &   ATCHAIN1(IAT),RESNUM1(IAT),COO1(1,IAT),COO1(2,IAT),
     &   COO1(3,IAT),ATDOMM(IAT)
        END IF
        IF (MODAT1(IAT) .NE. 0 .AND. IAT .EQ. NATOT1.AND. 
     &  ATCHAIN1(IAT).EQ.ATCHAIN1(IAT-1) ) THEN
           WRITE(IOUT6,2006)'TER'
        END IF
C	        
       END DO    
C============================================================================
C DETRMINING THE HINGAXES
C---------------------------------
      CALL HINGEAXES2(NDOM,NATOT1,DOMAT,DOMATOM
     &                ,RESNUM1,
     &                COO1,COO2,MASS,NDOMO,NCON,
     &                DOMCON,DOMORD,DOMCONAT,NCONAT,LCONAT,
     &                EXTINT,EXTCRIT,ATCHAIN1,DOMSIZE,IOUT1,IOUT6,IOUT7
     &                ,NPAIR,RESMAX1)
C
       WRITE(IOUT6,'(A)')'END' 
C====================================================
C  FORMATS
1000  FORMAT(A7,50(A4,A1,A4,A1,A1))
2000  FORMAT(A4,9X,A4,A4,A1,A5,3X,3F8.3)
2001  FORMAT(A4,9X,A4,A4,A1,I5,3X,3F8.3)     
2002  FORMAT(A4,2X,I5,2X,A4,A4,A1,I5,3X,3F8.3,6X,I6) 
2003  FORMAT(A4,2X,I5,2X,A4,A4,A1,A5,3X,3F8.3,6X,I6)
2006  FORMAT(A3)  
2010  FORMAT(A6,4X,I4)  
2011  FORMAT(A6)  
3000  FORMAT(A19) 
4000  FORMAT(A4,2X,I5,2X,A4,A4,A1,A5,3X,3F8.3)             
C======================================================
              WRITE (IOUT1,'(A80)') '===================================
     &=============================================' 
      WRITE(IOUT1,'(A)')' '
	WRITE (IOUT1,'(A,I2)')'TOTAL DYNAMIC DOMAIN PAIRS : ',NPAIR
        WRITE(IOUT1,'(A)')'	'
              WRITE (IOUT1,'(A80)') '***********************************
     &*********************************************' 	
        WRITE(IOUT1,'(A)')' END OF DynDom3D OUTPUT '      
        WRITE(IOUT1,'(A)')'	'
              WRITE (IOUT1,'(A80)') '***********************************
     &*********************************************' 
999    continue
      CLOSE (IN1)
      CLOSE (IN2)
      CLOSE (IOUT1)
      CLOSE (IOUT4)
      CLOSE (IOUT6)
                 
       STOP
       END

C-------------------------------------------------------------
C
C                       
C     Copyright by Steven Hayward et al., 2006.
C     DYNDOM 3D WINDOW VERSION
C
C-------------------------------------------------------------
