C                                                                       
C THIS FINDS THE DISTANCE BETWEEN THE CLOSURE AXIS AND THE LINE
C JOINING THE CENTRES OF MASS OF THE TWO DOMAINS.  IT ALSO FINDS 
C THE ANGLE BETWEEN THESE TWO LINES AND THE COMPONENTS OF THE ROTATION
C ABOUT THE INTERDOMAIN ROTATION AXIS THAT ARE THE TWIST AND CLOSURE MOTION
C
       SUBROUTINE CLOSURE(DOMA,DOMB,COO1,UNTHX,UNTHY,UNTHZ,XL,YL,ZL                    
     &                    ,IOUT1,DOMATOM,DOMAT,DOMCONAT,NCONAT)
C
       IMPLICIT NONE
C
       include 'DynDom.param'
C
       INTEGER DOMA,DOMB,IA,IB
       INTEGER IOUT1,DOMCONAT(NDOMX,NUMATMX),NCONAT(NDOMX)
       INTEGER DOMATOM(NDOMX,NUMATMX),DOMAT(NDOMX)
       INTEGER IAT,JAT
       REAL*8 COO1(3,*)
       REAL*8 UNTHX,UNTHY,UNTHZ,AXAN,AXDIST,CLOSEPER
       REAL*8 CLOSX,CLOSY,CLOSZ 
       REAL*8 XD,YD,ZD,RL,UNCMX,UNCMY,UNCMZ,GTW                       
       REAL*8 XL,YL,ZL,XCMA,YCMA,ZCMA,XCMB,YCMB,ZCMB                       
c-----------------------------------
C INITIALISATION
c-----------------------------------
        XCMA=0.0D0
        YCMA=0.0D0
        ZCMA=0.0D0
        IA=0
C-----------------------------------------------------------------------                                                                       
C CALCULATE APPROXIMATE LOCATIONS OF CENTRES OF MASS OF THE TWO DOMAINS 
C------------------------------------------------------------------------	
        DO 20 IAT=1,DOMAT(DOMA)
           JAT=DOMATOM(DOMA,IAT)
            IA=IA+1
            XCMA=XCMA+COO1(1,JAT)
            YCMA=YCMA+COO1(2,JAT)
            ZCMA=ZCMA+COO1(3,JAT)
10        CONTINUE
C
20      CONTINUE
C DIVIDE BY THE NUMBER OF ATOMS
        XCMA=XCMA/IA
        YCMA=YCMA/IA
        ZCMA=ZCMA/IA
C
        XCMB=0.0D0
        YCMB=0.0D0
        ZCMB=0.0D0
        IB=0
C	
        DO 21 IAT=1,DOMAT(DOMB)
           JAT=DOMATOM(DOMB,IAT)
            IB=IB+1
            XCMB=XCMB+COO1(1,JAT)
            YCMB=YCMB+COO1(2,JAT)
            ZCMB=ZCMB+COO1(3,JAT)
11        CONTINUE
C
21      CONTINUE
C
        XCMB=XCMB/IB
        YCMB=YCMB/IB
        ZCMB=ZCMB/IB
C----------------------------------------------------------------------- 
C DETERMINE UNIT VECTOR OF LINE JOINING CENTRES OF MASS OF TWO DOMAINS
C----------------------------------------------------------------------
        XD=XCMB-XCMA
        YD=YCMB-YCMA
        ZD=ZCMB-ZCMA
        RL=SQRT(XD**2+YD**2+ZD**2)
        UNCMX=XD/RL
        UNCMY=YD/RL
        UNCMZ=ZD/RL
C----------------------------------------------------------------
C DETERMINE ANGLE BETWEEN AXIS AND LINE JOINING CENTRES OF MASS
C----------------------------------------------------------------
        GTW=UNTHX*UNCMX+UNTHY*UNCMY+UNTHZ*UNCMZ
        AXAN=ACOS(GTW)  
        AXAN=AXAN*180.0/PI
        IF (AXAN.GT.90.0) AXAN=180.0-AXAN
C----------------------------------------------------------------
C DETERMINE COMPONENT OF INTERDOMAIN ROTATION ALONG LINE JOINING 
C CENTRES OF MASS, I.E. THE TWIST; AND LINE PERPENDICULAR, I.E
C CLOSURE MOTION
C------------------------------------------------------------------
        CLOSX=UNTHX-GTW*UNCMX
        CLOSY=UNTHY-GTW*UNCMY
        CLOSZ=UNTHZ-GTW*UNCMZ
        CLOSEPER=CLOSX**2+CLOSY**2+CLOSZ**2
        CLOSEPER=CLOSEPER*100
C--------------------------------------------------------------------
C DETERMINE DISTANCE BETWEEN AXIS AND LINE JOINING CENTRES OF MASS
C--------------------------------------------------------------------
        CALL LINEDIST(UNTHX,UNTHY,UNTHZ,UNCMX,UNCMY,UNCMZ,XL,YL,ZL
     &,XCMA,YCMA,ZCMA,AXDIST)
C---------------------------------------------------------------------
       WRITE (IOUT1,'(A58,F8.3)') 'ANGLE BETWEEN SCREW AXIS AND LINE JOI
     &NING CENTRES OF MASS:',AXAN
       WRITE (IOUT1,'(A61,F8.3,A2)') 'DISTANCE BETWEEN SCREW AXIS AND LI
     &NE JOINING CENTRES OF MASS:',AXDIST,' A'
       WRITE (IOUT1,'(A26,F8.3)') 'PERCENTAGE CLOSURE MOTION:',CLOSEPER
C
        RETURN
C	
        END
C
C-------------------------------------------------------------
C
C     Copyright by Steven Hayward
C     DynDom3D Version 
C
C-------------------------------------------------------------
C
