C
C K-MEANS CLUSTERING ROUTINE.
C
C ADAPTED FROM PROGRAM IN BOOK OF HARTIGAN, J.A. "CLUSTERING ALGORITHMS"
C NEW YORK: WILEY, 1975
C
C STOPS WHEN A CLUSTER DOESN'T POSSESS ANY DOMAINS WITH AT 
C LEAST AS MANY ATOMS AS THE MINIMUM SPECIFIED 
C
C RETURNED IS THE MAXIMUM NUMBER OF DOMAINS (PROVIDED NCLUSTER IS SET HIGH ENOUGH)
C FOR WHICH ALL DOMAIN PAIRS SATISFY THE CRITERION FOR THE RATIO OF
C EXTERNAL TO INTERNAL MOTION OR IF NOT AT LEAST ONE DOMAIN PAIR
C                                    
C contains correction for domsize 22 Feb 2010 sjh
C
      SUBROUTINE CLUSTER2_1(MM, M, N, A,  K, ITER,
     &           DMSUM1, DMSUM2, SUM, IWORKM, WORK,NDOMM,DOMIN, 
     &           NATOT,LCHAINID,GRDSIZE,BLKSIZE,
     &           ATBL,ATBLK,ATCLUS,INCLUS,CLUSCOUNT
     &           ,BLKIND,COO1,COO2,GCOO1,IGRID1,IGRIDAT1,
     &           GMAX1,MASS,DOMSIZEM,DOMATM,DOMATOMM,
     &           NDOMOM,NCONM,DOMCONM,DOMCONATM,NCONATM
     &           ,NCON,DOMORDM,EXTCRIT,EXTINTM,LCONAT,ATDROPNUM,
     &           ATDOMM,CLUSAT,CLUSATOM,CLUSOK,nullres)
C
C
      IMPLICIT NONE
      include 'DynDom.param'
C
      INTEGER N,M,MM,I,J,JJ,K,KK,KKK,KM,KN,ITER,NC
      INTEGER IAT,IVOTE(NUMATMX)
      INTEGER IBLK(NCLUSMX)
      INTEGER DMSUM1,DMSUM2,DCLUS,ND(NDOMX)
      INTEGER BLKSIZE,NATOT
      INTEGER INCLUS(NUMATMX,NCLUSMX),ATCLUS(NUMATMX)
      INTEGER CLUSATOM(NCLUSMX,NUMATMX),CLUSAT(NCLUSMX)
      INTEGER CLUSCOUNT(NUMATMX),ATDOMM(NUMATMX)
      INTEGER ATBL(NUMATMX),ATBLK(NUMATMX,*)
      INTEGER ATDOM(NUMATMX),ATDROPNUM(NUMATMX),DOMSIZE(NDOMX)
      INTEGER DOMSIZEM(NDOMX)
      INTEGER DOMCONAT(NDOMX,NUMATMX),NCONAT(NDOMX)
      INTEGER DOMCONATM(NDOMX,NUMATMX),NCONATM(NDOMX)      
      INTEGER BLKIND(0:NGRIDMX,0:NGRIDMX,
     &        0:NGRIDMX)
      INTEGER IGRID1(0:NGRIDMX,0:NGRIDMX,
     &        0:NGRIDMX)
       INTEGER IGRIDAT1(0:NGRIDMX,0:NGRIDMX,
     &        0:NGRIDMX,2*GRDATMX)
      INTEGER GCOO1(3,NUMATMX)    
      INTEGER GMAX1(3)
      INTEGER DOMIN
      INTEGER NDOM,NDOMM
      INTEGER DOMORDM(NDOMX),NDOMO
      INTEGER NCONM(NDOMX),DOMCONM(NDOMX,NDOMX)
      INTEGER DOMORD(NDOMX),NDOMOM
      INTEGER NCON(*),DOMCON(NDOMX,NDOMX)
      INTEGER IWORK(nblockmx),CLUSNO,NOTBEEN,CLUSYESBEF,CLUSYES
      INTEGER DOMATOM(NDOMX,NUMATMX),DOMAT(NDOMX)
      INTEGER DOMATOMM(NDOMX,NUMATMX),DOMATM(NDOMX)
      INTEGER IWORKM(nblockmx)
      REAL*8 COO1(3,NUMATMX),COO2(3,NUMATMX),MASS(*),EXTCRIT
      REAL*8 EXTINT(NDOMX,NDOMX),EXTINTM(NDOMX,*),GRDSIZE
      REAL*8 SUM(DMSUM1,DMSUM2,*),A(MM,*),WORK(*),ERR,SM
      LOGICAL OK,ALLOK,ALLOKDONE,BEEN,LCONAT(NUMATMX),VOTEOK,SETOK
      LOGICAL OKDONE,CLUSOK,LCHAINID,nullres
      CHARACTER*1 ATCHAIN(NUMATMX)
C
C================================================
C INITIALISATION
C==================================================
      nullres=.false.
      BEEN=.FALSE.
      NOTBEEN=0
      CLUSYES=1
      CLUSYESBEF=1
      CLUSOK=.TRUE.
      ALLOKDONE=.FALSE.
      DCLUS = 2*N + M
C----------------------------------------------------
      DO 10 I=1,7
         DO 10 J=1,N
            DO 10 KK=1,K+1
   10          SUM(I,J,KK)=0.
C-------------------------------------------------
C     LOOP ONCE FOR EACH DESIRED CLUSTER
C-----------------------------------------------------
      DO 130 KK=1,K
C-----------------------------------------------------------------------
         IF(KK.GT.NDOMX) THEN  
           WRITE(6,'(A,I4,I4)')'ARRAY BOUNDARY FOR NUMBER OF DOMAINS HAS 
     & BEEN EXCEEDED: ',NDOMX,KK
           WRITE(6,'(A)')'CHANGE VALUE FOR "NDOMX" IN "DYNDOM.PARAM"'
           WRITE(6,'(A)')'RETURNING FROM CLUSTER AT CLUSTER ',KK
           RETURN
         ENDIF
C-------------------------------------------------------
         WRITE(6,'(A)')
         WRITE(6,'(A,I4)')'NUMBER OF CLUSTERS:',KK
         WRITE(6,'(A)')' '	 
C-------------------------------------------------------
C
         DO 60 NC=1,ITER
            ERR=0.
            DO 20 KKK=1,KK
               DO 20 J=1,N
                  IF(NC.EQ.1.OR.SUM(1,J,KKK).NE.SUM(3,J,KKK)) ERR=1.
   20       CONTINUE
C-------------------------------------------------------------------
C     IF NO CHANGES HAVE BEEN MADE, OUTPUT THE CLUSTER
C
            IF(ERR.EQ.0.) GO TO 70
C	    
            DO 30 KKK=1,KK
               DO 30 J=1,N
                  SUM(2,J,KKK)=0.
   30       SUM(1,J,KKK)=SUM(3,J,KKK)
            DO 50 I=1,M
               DO 40 J=1,N
   40             WORK(J)=A(I,J)
               IWORK(I)=NC
C---------------------------------------------------------------------
C     FIND BEST CLUSTER FOR CASE I
C
               CALL KMEANS(N, WORK, KK,  DMSUM1, DMSUM2, SUM,
     &                     IWORK(I), WORK(DCLUS+I))
C----------------------------------------------------------------------     
   50       CONTINUE
   60    CONTINUE
C
   70    CONTINUE 
C
         IF(KK.EQ.1) GOTO 16
c         IF(KK.NE.3) GOTO 16
C

C---------------------------------------------------------------------         
C ASSIGINING THE CLUSTER VALUE TO THE APPROPRIATE BLOCKS
C---------------------------------------------------------------------
        DO IAT=1,KK
           IBLK(IAT)=0
        END DO 
	
        DO  IAT=1,M
            IBLK(IWORK(IAT))=IBLK(IWORK(IAT))+1
        END DO
C-----------------------------------------------------------------------      
C IF THE CLUSTERING ALGORTIHM LAVES ANY CLUSTER WITH ZERO VALUES
C THEN GIVE WARNING AND STOP.      
C-----------------------------------------------------------------------
         DO IAT=1,KK
           IF (IBLK(IAT) .EQ. 0 )THEN
            WRITE(6,*)' CLUSTERING YIELDS ZERO BLOCKS '
            WRITE(6,*)' EXITING CLUSTERING ROUTINE AT CLUSTER ',KK
            WRITE(6,*)' ALTER PARAMETER OR TRY DIFFERENT CONFORMER '
	     CLUSOK=.FALSE.
             RETURN
           END IF
         END DO
C=======================================================================
C   VOTE FOR EACH ATOM AND ASSIGN THE ATOM TO EACH CLUSTER
C
          CALL VOTE(NATOT,DOMIN,COO1,IGRID1,IGRIDAT1,
     &              GMAX1,GRDSIZE,KK,IWORK,ATBL,ATBLK,IVOTE,ATCLUS
     &              ,CLUSATOM,CLUSAT,INCLUS,CLUSCOUNT,VOTEOK)
C---------------------------------------------------------------------     
          IF (.NOT.VOTEOK) THEN
	    WRITE(6,*)' VOTING YIELDS ATOMS LESS THAN DOMIN VALUE '
	    IF(KK .GT. 2 ) THEN
	       WRITE(6,*)' DOMAIN INFO WILL BE FROM PREVIOUS CLUSTER '
	     ELSE
               nullres=.true.
	     END IF  
	    WRITE(6,*)' EXITING CLUSTER ROUTINE '
	     CLUSOK=.FALSE.
            RETURN 
	  END IF

C=======================================================================
          CLUSYESBEF=CLUSYES
          NDOM=KK       
C------------------------------------------------------------------
C USING CONNECTED SET ALGORITHM TECHNIQUE FIND THE CONNECTED SETS
C AND ASSIGN DOMAINS
          CALL CONNSET2(NATOT,LCHAINID,KK,ATCLUS,CLUSATOM,CLUSAT,DOMIN,
     &                  NDOM,COO1,COO2,GRDSIZE,IGRID1,IGRIDAT1,
     &                  GMAX1,CLUSNO,DOMSIZE,DOMATOM,
     &                  DOMAT,ATDOM,SETOK,ATCHAIN)
C--------------------------------------------------------------------
          IF (.NOT. SETOK) THEN
            WRITE(6,*)' RETURNING FROM CONNSET : '
	    WRITE(6,*)' DOMAIN INFO WILL BE FROM PREVIOUS CLUSTER '
	      CLUSOK=.FALSE.
              if(kk.eq.2) nullres=.true.
               RETURN 
	  END IF 
C-------------------------------------------------------------------     
               CLUSYES=KK-CLUSNO               
C-------------------------------------------------------------------                
C THE FOLLOWING CONDITIONAL ALLOWS IT TO LOOK FOR CLUSTERS
C WITH DOMAINS LARGER THAN DOMIN EVEN IF AT THE OUTSET IT
C FINDS ONLY CLUSTERS THAT GIVE DOMAINS SMALLER THAN DOMIN
C
C-------------------------------------------------------------------
        IF( SETOK) THEN
C
           IF(NDOM.GE.2) THEN
             BEEN=.TRUE.
           ENDIF
Cc-----------------------------------------------------------------------
                 WRITE(6,'(A,I4)')'NUMBER OF DOMAINS EQUAL TO OR LARGER 
     &THAN MINIMUM DOMAIN SIZE:',NDOM
C
C=====================================================================
C DETERMINES MOST CONNECTED DOMAIN, AND THEN SECOND MOST CONNECTED
C DOMAIN AND SO ON.ORDER THE DOMAINS ACCORDING TO THEIR DEGREE OF 
C CONNECTIVITY 

           CALL DOMCONNECT2 (NATOT,NDOM,DOMSIZE,DOMIN,COO1,COO2,GMAX1,
     &	                     GRDSIZE,IGRID1,IGRIDAT1,
     &                       DOMATOM,DOMAT,ATDOM,NDOMO,DOMORD,DOMCON
     &                       ,DOMCONAT,NCONAT,ND,NCON,LCONAT)
C=======================================================================
C CALCULATE RATIO OF INTERDOMAIN TO INTRADOMAIN DISPLACEMENT FOR ALL
C CONNECTED DOMAIN PAIRS
C
           CALL EXTSTOP2(NATOT,NDOM,COO1,COO2,DOMATOM,DOMAT,MASS
     &                   ,OKDONE,ALLOK,NDOMO,NCON,DOMCON,DOMORD,
     &                   EXTCRIT,EXTINT)
C            
C=========================================================================
C REMEMBER DOMAIN INFO IF ALL DOMAIN PAIRS SATISFY THE CRITERION FOR 
C THE RATIO OF INTERDOMAIN TO INTRADOMAIN DISPLACEMENT
C--------------------------------------------------------------------
C FOLLOWING IS FOR THE CONDITION OF ALL THE DOMAIN PAIRS
C SATISFYING THE RATIO CRITERION
C--------------------------------------------------------------------
           ALLOKDONE=.FALSE.
           IF(ALLOK) THEN
C INITIALISE TO REMOVE THE PREVIOUS VALUES	   
	    DO I=1,NDOMX
                 DOMSIZEM(I)=DOMSIZE(I)
	         DOMATM(I)=0
	         NCONATM(I)=0
	      DO IAT=1,NATOT
	         DOMATOMM(I,IAT)=0
		 DOMCONATM(I,IAT)=0  
	      END DO
C	      
	      DO J=1,NDOMX
	         EXTINTM(I,J)=0
	         DOMCONM(I,J)=0
	      END DO
C	      
	    END DO
C	    
	     DO IAT=1,NATOT
	         ATDOMM(IAT)=0
	     END DO
c
	     DO J=1,M
	        IWORKM(J)=0 
	     END DO	     
C--------------------------------------------------------------------	   
           WRITE(6,'(A)')' ' 
                     WRITE(6,*)' ALL THE POSSIBLE DOMAIN PAIRS SATISFY
     &RATIO CRITERION FOR CLUSTER ',KK 
           WRITE(6,'(A)')' '
C
                  ALLOKDONE=.TRUE.
C--------------------------------------------------------------
C NOW ASSIGN THE DOMAIN INFORMATION 
C--------------------------------------------------------------
             NDOMM=NDOM
           DO J=1,M
	        IWORKM(J)=IWORK(J) 
	   END DO	     
  
	   DO I = 1,NDOMM
	         DOMATM(I)=DOMAT(I)
	         NCONATM(I)=NCONAT(I)
	    DO J = 1,DOMAT(I)
	           ATDOMM(DOMATOM(I,J))=ATDOM(DOMATOM(I,J))
	           DOMATOMM(I,J)=DOMATOM(I,J)
	    END DO   
	     DO J=1,NCONAT(I)
	            DOMCONATM(I,J)=DOMCONAT(I,J)
	     END DO
	   END DO  
C         
             NDOMOM=NDOMO
             DO 13 I=1,NDOMOM
                   DOMORDM(I)=DOMORD(I)
                   NCONM(DOMORDM(I))=NCON(DOMORD(I))
               DO 14 J=1,NCONM(DOMORDM(I))
                        DOMCONM(DOMORDM(I),J)=DOMCON(DOMORD(I),J)
                        EXTINTM(DOMORDM(I), DOMCONM(DOMORDM(I),J))=
     &                  EXTINT(DOMORD(I), DOMCON(DOMORD(I),J))
14             CONTINUE                
13           CONTINUE
C------------------------------------------------------------------
C TO DO FOR CASES WHERE DOMAIN PAIRS NOT SATISFYING RATIO CRITERION
C------------------------------------------------------------------
           ELSEIF(.NOT.ALLOKDONE.AND.OKDONE) THEN
C
           WRITE(6,'(A)')' '
	     WRITE(6,*)'CLUSTERING IS CONTINUED TILL ALL POSSIBLE
     & DOMAINS PAIRS SATISFY THE RATIO CRITERION'
C	     WRITE(6,*)'RETURNING TO NEXT CLUSTER '
           WRITE(6,'(A)')' '
C	     
    	      OK=.TRUE.
C	    
           END IF
C-------------------------------------------------------------------
C TO DO FOR CASES WHERE NONE OF THE DOMAIN PAIRS SATISFY THE RATIO CRITERION
C------------------------------------------------------------------
         ELSEIF (.NOT. CLUSOK) THEN
           WRITE(6,'(A)')' '	 
           WRITE(6,'(A)')'FOUND CLUSTER WITH DOMAINS LESS THAN 
     & MINIMUM DOMAIN SIZE'
C
           WRITE(6,'(A)')'EXITING CLUSTERING ROUTINE'
           WRITE(6,'(A)')
C
           RETURN
C	   
        END IF
C====================================================================          
C
C CREATE A NEW CLUSTER BY SPLITTING VARIABLE WITH LARGEST WITHIN-
C CLUSTER VARIANCE AT THAT VALUE OF THAT VARIABLE AT THE CENTER
C OF THE CLUSTER
C
16       CONTINUE

         SM=0.
         DO 80 J=1,N
            DO 80 KKK=1,KK
               IF(SUM(4,J,KKK).GE.SM) THEN
                  SM=SUM(4,J,KKK)
                  KM=KKK
               ENDIF
   80    CONTINUE
         KN=KK+1
         DO 90 JJ=1,N
            SUM(2,JJ,KM)=0.
            SUM(3,JJ,KM)=0.
            SUM(2,JJ,KN)=0.
   90       SUM(3,JJ,KN)=0.
         DO 110 I=1,M
            IF(IWORK(I).EQ.KM) THEN
               DO 100 JJ=1,N
                  IF(A(I,JJ).GE.SUM(1,JJ,KM)) THEN
                     SUM(2,JJ,KN)=SUM(2,JJ,KN)+1
                     SUM(3,JJ,KN)=SUM(3,JJ,KN)+A(I,JJ)
                  ELSE
                     SUM(2,JJ,KM)=SUM(2,JJ,KM)+1
                     SUM(3,JJ,KM)=SUM(3,JJ,KM)+A(I,JJ)
                  ENDIF
  100          CONTINUE
            ENDIF
  110    CONTINUE
         DO 120 JJ=1,N
            IF(SUM(2,JJ,KN).NE.0.)SUM(3,JJ,KN)=SUM(3,JJ,KN)/SUM(2,JJ,KN)
            IF(SUM(2,JJ,KM).NE.0.)SUM(3,JJ,KM)=SUM(3,JJ,KM)/SUM(2,JJ,KM)
  120    CONTINUE
  130 CONTINUE

        
      RETURN
      END
C
C-------------------------------------------------------------
C
C     Copyright by Steven Hayward et. al, 2006.
C     DynDom 3D window version
C
C-------------------------------------------------------------
