C 
C SUBROUTINE TO CALCULATE EXTERNAL AND INTERNAL MSF'S
C 
      SUBROUTINE EXTMSF (N,MASS,CO1,CO2,VEXTMSF,VINTMSF,VMSF)
C 
      IMPLICIT NONE
C
      include 'DynDom.param'
C 
      INTEGER I,N,IER
      REAL*8 MASS(*),R(3,3),RC1(3),RC2(3),RMSD
      REAL*8 CO1(3,*),CO2(3,*)
      REAL*8 COSAV1(3,NUMATMX)
      REAL*8 VEXTX,VEXTY,VEXTZ,VEXTMSF
      REAL*8 VINTMSF
      REAL*8 VX,VY,VZ,VMSF
      REAL*8 Q(4),ROT(3),THETA
C=================================
C INITIALISATION
      VMSF=0.0D0
      ROT(1)=0.0D0
      ROT(2)=0.0D0
      ROT(3)=0.0D0      
C===================================      
      DO 8 I=1,N
           VX=CO2(1,I)-CO1(1,I)
           VY=CO2(2,I)-CO1(2,I)
           VZ=CO2(3,I)-CO1(3,I)
           VMSF=VMSF+(VX**2+VY**2+VZ**2)
8     CONTINUE
C
      DO 10 I=1,N
            COSAV1(1,I)=CO1(1,I)
            COSAV1(2,I)=CO1(2,I)
            COSAV1(3,I)=CO1(3,I)
10    CONTINUE
C 
       CALL QTFIT(N,CO2,CO1,RMSD,RC2,RC1,R,IER,MASS,Q,ROT,THETA)
C
      VINTMSF=(RMSD**2)*N
C
      VEXTMSF=0.0
      DO 9 I=1,N
           VEXTX=CO1(1,I)-COSAV1(1,I)+RC2(1)
           VEXTY=CO1(2,I)-COSAV1(2,I)+RC2(2)
           VEXTZ=CO1(3,I)-COSAV1(3,I)+RC2(3)
           VEXTMSF=VEXTMSF+(VEXTX**2+VEXTY**2+VEXTZ**2)
9     CONTINUE
C
      RETURN
      END
C
C-------------------------------------------------------------
C
C                       
C     Copyright by Steven Hayward et al, 2006.
C     DynDom3D Version with Quaternion best fit
C
C-------------------------------------------------------------
C

