C      ADAPTED FROM THE PROCEDURE IN NUMERICAL RECIPES.
C 
C     "JACOBI" PERFORMS A MATRIX DIAGONALIZATION OF A REAL
C     SYMMETRIC MATRIX BY THE METHOD OF JACOBI ROTATIONS
C
C     VARIABLES AND PARAMETERS:
C
C     N     LOGICAL DIMENSION OF THE MATRIX TO BE DIAGONALIZED
C     NP    PHYSICAL DIMENSION OF THE MATRIX STORAGE AREA
C     A     INPUT WITH THE MATRIX TO BE DIAGONALIZED; ONLY
C              THE UPPER TRIANGLE AND DIAGONAL ARE REQUIRED
C     D     RETURNED WITH THE EIGENVALUES IN ASCENDING ORDER
C     V     RETURNED WITH THE EIGENVECTORS OF THE MATRIX
C     B     TEMPORARY WORK VECTOR
C     Z     TEMPORARY WORK VECTOR
C
C
      SUBROUTINE JACOBI (N,NP,A,D,V,B,Z,NROT)
      IMPLICIT NONE

      INTEGER I,J,K
      INTEGER N,NP,IP,IQ
      INTEGER NROT,MAXROT
      REAL*8 SM,TRESH,S,C,T
      REAL*8 THETA,TAU,H,G,P
      REAL*8 D(NP),B(NP),Z(NP)
      REAL*8 A(NP,NP),V(NP,NP)
C
C
C     SETUP AND INITIALIZATION
C
      MAXROT = 100
      NROT = 0
      DO IP = 1, N
         DO IQ = 1, N
            V(IP,IQ) = 0.0D0
         END DO
         V(IP,IP) = 1.0D0
      END DO
      DO IP = 1, N
         B(IP) = A(IP,IP)
         D(IP) = B(IP)
         Z(IP) = 0.0D0
      END DO
C
C     PERFORM THE JACOBI ROTATIONS
C
      DO I = 1, MAXROT
         SM = 0.0D0
         DO IP = 1, N-1
            DO IQ = IP+1, N
               SM = SM + ABS(A(IP,IQ))
            END DO
         END DO
         IF (SM .EQ. 0.0D0)  GOTO 10
         IF (I .LT. 4) THEN
            TRESH = 0.2D0*SM / N**2
         ELSE
            TRESH = 0.0D0
         END IF
         DO IP = 1, N-1
            DO IQ = IP+1, N
               G = 100.0D0 * ABS(A(IP,IQ))
               IF (I.GT.4 .AND. ABS(D(IP))+G.EQ.ABS(D(IP))
     &                    .AND. ABS(D(IQ))+G.EQ.ABS(D(IQ))) THEN
                  A(IP,IQ) = 0.0D0
               ELSE IF (ABS(A(IP,IQ)) .GT. TRESH) THEN
                  H = D(IQ) - D(IP)
                  IF (ABS(H)+G .EQ. ABS(H)) THEN
                     T = A(IP,IQ) / H
                  ELSE
                     THETA = 0.5D0*H / A(IP,IQ)
                     T = 1.0D0 / (ABS(THETA)+SQRT(1.0D0+THETA**2))
                     IF (THETA .LT. 0.0D0)  T = -T
                  END IF
                  C = 1.0D0 / SQRT(1.0D0+T**2)
                  S = T * C
                  TAU = S / (1.0D0+C)
                  H = T * A(IP,IQ)
                  Z(IP) = Z(IP) - H
                  Z(IQ) = Z(IQ) + H
                  D(IP) = D(IP) - H
                  D(IQ) = D(IQ) + H
                  A(IP,IQ) = 0.0D0
                  DO J = 1, IP-1
                     G = A(J,IP)
                     H = A(J,IQ)
                     A(J,IP) = G - S*(H+G*TAU)
                     A(J,IQ) = H + S*(G-H*TAU)
                  END DO
                  DO J = IP+1, IQ-1
                     G = A(IP,J)
                     H = A(J,IQ)
                     A(IP,J) = G - S*(H+G*TAU)
                     A(J,IQ) = H + S*(G-H*TAU)
                  END DO
                  DO J = IQ+1, N
                     G = A(IP,J)
                     H = A(IQ,J)
                     A(IP,J) = G - S*(H+G*TAU)
                     A(IQ,J) = H + S*(G-H*TAU)
                  END DO
                  DO J = 1, N
                     G = V(J,IP)
                     H = V(J,IQ)
                     V(J,IP) = G - S*(H+G*TAU)
                     V(J,IQ) = H + S*(G-H*TAU)
                  END DO
                  NROT = NROT + 1
               END IF
            END DO
         END DO
         DO IP = 1, N
            B(IP) = B(IP) + Z(IP)
            D(IP) = B(IP)
            Z(IP) = 0.0D0
         END DO
      END DO
C
C     PRINT WARNING IF NOT CONVERGED
C
   10 CONTINUE
      IF (NROT .EQ. MAXROT) THEN
         WRITE (6,20)
   20    FORMAT (/,' JACOBI  --  MATRIX DIAGONALIZATION NOT CONVERGED')
      END IF
C
C     SORT THE EIGENVALUES AND VECTORS
C
      DO I = 1, N-1
         K = I
         P = D(I)
         DO J = I+1, N
            IF (D(J) .LT. P) THEN
               K = J
               P = D(J)
            END IF
         END DO
         IF (K .NE. I) THEN
            D(K) = D(I)
            D(I) = P
            DO J = 1, N
               P = V(J,I)
               V(J,I) = V(J,K)
               V(J,K) = P
            END DO
         END IF
      END DO
      RETURN
      END
