C 
C ROUTINE TO MODEL CB ATOM ON A GLYCINE
C
      SUBROUTINE MODCBETA(COO)
C
      IMPLICIT NONE
      include 'DynDom.param'
C
        
      REAL*8 COO(3,NUMATMX),XX,XY,XZ,YX,YY,YZ,ZX,ZY,ZZ
      REAL*8 DIST,CACX,CACY,CACZ,CBX,CBY,CBZ
C
      XX=COO(1,1)-COO(1,2)
      XY=COO(2,1)-COO(2,2)
      XZ=COO(3,1)-COO(3,2)
C
      DIST=XX**2+XY**2+XZ**2
      DIST=SQRT(DIST)
C
      XX=XX/DIST
      XY=XY/DIST
      XZ=XZ/DIST
C
      CACX=COO(1,3)-COO(1,2)
      CACY=COO(2,3)-COO(2,2)
      CACZ=COO(3,3)-COO(3,2)
C
      CALL VECPROD(XX,XY,XZ,CACX,CACY,CACZ,ZX,ZY,ZZ)
C
      DIST=ZX**2+ZY**2+ZZ**2
      DIST=SQRT(DIST)
C
      ZX=ZX/DIST
      ZY=ZY/DIST
      ZZ=ZZ/DIST
C
      CALL VECPROD(ZX,ZY,ZZ,XX,XY,XZ,YX,YY,YZ)
C
      CBX=-0.4634449489765239
      CBY=-0.7956993679322285
      CBZ=1.224484501796736
C
      COO(1,4)=COO(1,2)+(CBX*XX+CBY*YX+CBZ*ZX)
      COO(2,4)=COO(2,2)+(CBX*XY+CBY*YY+CBZ*ZY)
      COO(3,4)=COO(3,2)+(CBX*XZ+CBY*YZ+CBZ*ZZ)
C
      RETURN
      END
C
C-------------------------------------------------------------
C
C     Copyright by Steven Hayward, 2002.
C     DynDom Version 1.5
C
C-------------------------------------------------------------
C
