C
C ROUTINE TO DETERMINE SCREW AXES OF DYNAMICAL DOMAINS
C
        SUBROUTINE SCREWAX(N,CO,V,AMPTHET,UNTHX,UNTHY,UNTHZ
     &                     ,AMPTR,XAX1,YAX1,ZAX1)
C
       IMPLICIT NONE
C
       include 'DynDom.param'
C
       INTEGER M,N
       REAL*8 V(*),COMP1
       REAL*8 TRPARX1,TRPARY1,TRPARZ1
       REAL*8 ROTX1,ROTY1,ROTZ1
       REAL*8 AMPROT1
       REAL*8 UNROTX1,UNROTY1,UNROTZ1
       REAL*8 AXIX1,AXIY1,AXIZ1
       REAL*8 RAXIX1,RAXIY1,RAXIZ1
       REAL*8 XAX1,YAX1,ZAX1
       REAL*8 CO(3,*),HTAN,AMPTR
       REAL*8 UNTHX,UNTHY,UNTHZ,AMPTHET 
C--------------------------------------------------
c initilaisation if any
          M=0
c---------------------------------------------------	  
C
          COMP1=V(1*3-2)*UNTHX+V(1*3-1)*UNTHY+V(1*3)*UNTHZ
          TRPARX1=COMP1*UNTHX
          TRPARY1=COMP1*UNTHY
          TRPARZ1=COMP1*UNTHZ
           AMPTR=COMP1
C--------------------------------------------------------------------------
C NOW CALCULATE DIFFERENCE BETWEEN DISPLACEMENTS AND PARALLEL TRANSLATIONS
C TO GIVE ROTATIONAL PARTS
C--------------------------------------------------------------------------
          ROTX1=V(1*3-2)-TRPARX1
          ROTY1=V(1*3-1)-TRPARY1
          ROTZ1=V(1*3  )-TRPARZ1
C
          AMPROT1=SQRT(ROTX1**2+ROTY1**2+ROTZ1**2)
C----------------------------------------------------------------------
C CALCULATE UNIT VECTORS IN DIRECTION OF ROTATIONAL PARTS
C----------------------------------------------------------------------
          UNROTX1=ROTX1/AMPROT1
          UNROTY1=ROTY1/AMPROT1
          UNROTZ1=ROTZ1/AMPROT1
C-------------------------------------------------------------------------
C CALCULATE VECTORS IN DIRECTION FROM ATOMS TO AXIS (PERPENDICULARLY)
C------------------------------------------------------------------------
          AXIX1=(UNROTY1*UNTHZ-UNROTZ1*UNTHY)
          AXIY1=(UNROTZ1*UNTHX-UNROTX1*UNTHZ)
          AXIZ1=(UNROTX1*UNTHY-UNROTY1*UNTHX)
C
          HTAN=2*TAN(0.5*AMPTHET)
          RAXIX1=AMPROT1*AXIX1/HTAN
          RAXIY1=AMPROT1*AXIY1/HTAN
          RAXIZ1=AMPROT1*AXIZ1/HTAN
C-------------------------------------------------------------------------
C SUBSTRACT THESE VECTORS FROM POSITION VECTORS TO GET POINTS ON AXIS
C-------------------------------------------------------------------------
          XAX1=CO(1,N)+(0.5*ROTX1)-RAXIX1
          YAX1=CO(2,N)+(0.5*ROTY1)-RAXIY1
          ZAX1=CO(3,N)+(0.5*ROTZ1)-RAXIZ1
C ---------------------------------------------------------------------------
        RETURN
C                                                            
        END                                                             
C
C-------------------------------------------------------------
C
C     Copyright by Steven Hayward et.al
C     DynDom3D  
C
C-------------------------------------------------------------
C
