C THIS SUBROUTINE DETERMINES THE ATOMS WHICH HAVE CONTACTS 
C WITH THE OTHER DOMAINS AND MAY BE THE BENDING ATOMS CONNECTING DOMAINS.
C THIS SUBROUTINE USES THE neighbour INFORMATION FOR DETERMINING 
c CONTACTING ATOMS AMONG DOMAINS WHICH IS MUCH QUICKER THAN THE 
c CONVENTIONAL ALL ATOM DISTANCE 

       SUBROUTINE SET2GRID(NATOT,NDOM,DOMSIZE,DOMIN,COO1,COO2,GMAX,
     &                     GRDSIZE,IGRID,IGRIDAT,DOMATOM,
     &                     DOMAT,ATDOM,DOMCON,NCON,DOMCONAT,NCONAT,
     &                     LCONAT)
C
       IMPLICIT NONE
C
       include 'DynDom.param'
C
       INTEGER NATOT,NDOM,J,IDOM,NCONAT(NDOMX)
       INTEGER JDOM,DOMSIZE(NDOMX),DOMIN
       INTEGER NCON(*),DOMCON(NDOMX,NDOMX)
       INTEGER IAT,IAT1,JAT,KAT,IX,IY,IZ,X,Y,Z,NI(NDOMX)
       INTEGER IGRID(0:NGRIDMX,0:NGRIDMX,0:NGRIDMX)
       INTEGER IGRIDAT(0:NGRIDMX,0:NGRIDMX,0:NGRIDMX,2*GRDATMX)
       INTEGER DOMATOM(NDOMX,NUMATMX),DOMAT(NDOMX)
       INTEGER GMAX(3),ATDOM(NUMATMX)
       INTEGER DOMCONAT(NDOMX,NUMATMX)
       REAL*8  DIST2,DIST1,GRDSIZE
       REAL*8  COO1(3,NUMATMX),COO2(3,NUMATMX),T1,T2
       LOGICAL CON1,CON2,LCONAT(NUMATMX),LDOMCON(NDOMX,NDOMX)
       LOGICAL LDOMCON2(NDOMX,NDOMX)
C--------------------------
C INTIALISATION
C-------------------------
        DO IDOM=1,NDOM
           NCONAT(IDOM)=0
       	   NI(IDOM)=0
    	   NCON(IDOM)=0	    
	 DO J=1,NATOT
	    DOMCONAT(IDOM,J)=0
         END DO 
         DO JDOM =1,NDOM
             LDOMCON(IDOM,JDOM)=.FALSE.
	     LDOMCON2(IDOM,JDOM)=.FALSE.
             DOMCON(IDOM,JDOM)=0
         END DO 
        END DO    
c	
        DO IAT=1,NATOT
           LCONAT(IAT)=.FALSE.
        END DO   
           CON1=.FALSE.
           CON2=.FALSE.
c---------------------------------
C CALCULATE THE TIME                   	
C----------------------------------
         CALL CPU_TIME(T1) 
c================================================	 
C BELOW IS FOR BOTH CONFORMATIONS
c=================================================
       DO IDOM=1,NDOM
        DO IAT=1,DOMAT(IDOM)
            IAT1=DOMATOM(IDOM,IAT)
	    IX=COO1(1,IAT1)/GRDSIZE
	    IY=COO1(2,IAT1)/GRDSIZE
	    IZ=COO1(3,IAT1)/GRDSIZE
C modifications made for avoiding joinfrag procedure 
c changed from neigbouring grid position search 1 to 2 	    
	  DO X=IX-2,IX+2
	   DO Y=IY-2,IY+2
	    DO Z=IZ-2,IZ+2
C	    
	     IF (X.GT. GMAX(1) .OR. X .LT. 0 ) GO TO 1
	     IF (Y.GT. GMAX(2) .OR. Y .LT. 0 ) GO TO 1	     
	     IF (Z.GT. GMAX(3) .OR. Z .LT. 0 ) GO TO 1
	     IF (IGRID(X,Y,Z) .EQ. 0 ) GO TO 1
C	     
	      DO JAT=1,IGRID(X,Y,Z)
	         KAT=IGRIDAT(X,Y,Z,JAT)

	        IF(ATDOM(KAT) .GT. 0 .AND. ATDOM(KAT) .NE. IDOM)THEN
C	      
	           CALL POINTDIST(IAT1,KAT,COO1,DOMDISTCRIT,DIST1,CON1)
C
                  IF (CON1) THEN		
C		  
		   CALL POINTDIST(IAT1,KAT,COO2,DOMDISTCRIT,DIST2,CON2)
C		   
		     IF (.NOT. LDOMCON2(IDOM,ATDOM(KAT)) .AND. CON2)THEN
 		      LDOMCON2(IDOM,ATDOM(KAT))=.TRUE.		     
		       LDOMCON(IDOM,ATDOM(KAT))=.TRUE.
		       NCON(IDOM)=NCON(IDOM)+1
		       DOMCON(IDOM,NCON(IDOM))=ATDOM(KAT)
		     END IF
 		      		      
C		   
		     IF (CON1 .AND. CON2) THEN 
		      LCONAT(IAT1)=.TRUE. 
		      IF (NCONAT(IDOM) .GE. NUMATMX) THEN
      WRITE(6,*)' WARNING : MAXIMUM NUMBER OF CONTACTS EXCEEDS NUMATMX '
      WRITE(6,*)' SEVERE ERROR : STOPPING AT SET2GRID ROUTINE '
		      STOP
		      END IF 
      		      NCONAT(IDOM)=NCONAT(IDOM)+1		      
                      DOMCONAT(IDOM,NCONAT(IDOM))=KAT
		     END IF
 		  END IF 
	        END IF 
C		
	      END DO	     
1	     CONTINUE
	    END DO
	   END DO
	  END DO 
C
        END DO 
C	  	
c-----------------------------------------	
       END DO 	
c---------------------------------
c substract intial from final time
c----------------------------------       
        CALL CPU_TIME(T2)
	  
       RETURN
       END	 
C-------------------------------------------------------------
C
C     Copyright by Steven Hayward, 2006.
C     DynDom 3D WINDOW GRID VERSION
C
C-------------------------------------------------------------
C


