C RATIO OF EXTERNAL TO INTERNAL MOTION FOR A PAIR OF DOMAINS
C INDEPENDENT OF RELATIVE SIZE OF DOMAINS. CALCULATED BY 
C "MASS" WEIGHTING BY INVERSE OF NUMBER OF RESIDUES IN DOMAIN
C
      SUBROUTINE EXTSTOP2 (NATOT,NDOM,COO1,COO2,DOMATOM,DOMAT,
     &                     MASS,ONEOK,ALLOK,NDOMO,NCON,DOMCON,
     &                     DOMORD,EXTCRIT,EXTINT)
C 
      IMPLICIT NONE
C 
      include 'DynDom.param'
C 
      INTEGER NDOM,DOMORD(*),NDOMO,IAT
      INTEGER NCON(*),DOMCON(NDOMX,*)
      INTEGER NATOT,NTOT,IER
      INTEGER DOMAT(NDOMX),DOMATOM(NDOMX,NUMATMX)
      INTEGER I,M,NDOMA,NDOMB!,ISEG,NSEG(*)
      INTEGER IDOM,JDOM,IORD,JORD,NOCONDOM
      REAL*8 MASS(*),R(3,3),RC1(3),AC1(3),RMSD
      REAL*8 COO1(3,NUMATMX),COO2(3,NUMATMX)
      REAL*8 CO1(3,NUMATMX),CO2(3,NUMATMX)
      REAL*8 VEXTMSFA,VINTMSFA,VMSFA
      REAL*8 VEXTMSFB,VINTMSFB,VMSFB
      REAL*8 VEXT,VINT,EXTCRIT
      REAL*8 EXTINT(NDOMX,*)
      REAL*8 Q(4),UNV(3),THETA
      LOGICAL ONEOK,ALLOK
C
C==================================
C INTIALISATION
C---------------------------------- 
      ONEOK=.FALSE.
      ALLOK=.TRUE.
       NOCONDOM=0
c      RMSD=0.0D0
c      VEXTMSFA=0.0D0
c      VINTMSFA=0.0D0
c      VMSFA=0.0D0
c      VEXTMSFB=0.0D0
c      VINTMSFB=0.0D0
c      VMSFB=0.0D0
c      VEXT=0.0D0
c      VINT=0.0D0
c      EXTCRIT=0.0D0
C
      DO IDOM=1,NDOMX
       DO JDOM=1,NDOMX
          EXTINT(IDOM,JDOM)=0.0d0
       END DO
      END DO
      DO IAT=1,NATOT              
         CO1(1,IAT)=0.0D0
	 CO1(2,IAT)=0.0D0
	 CO1(3,IAT)=0.0D0
         CO2(1,IAT)=0.0D0
	 CO2(2,IAT)=0.0D0
	 CO2(3,IAT)=0.0D0	 
      END DO
C====================================
C DETERMINE THE RATIO OF INTERDOMAIN TO 
C INTRADOMAIN DISPLACEMENT
C FOR THE ORDERED DOMAIN PAIRS
C========================================       
C
      DO 80 IORD=1,NDOMO
        IDOM=DOMORD(IORD)
C DOMAIN A
        NOCONDOM=0 
        M=0

        DO 20 IAT=1,DOMAT(IDOM)
               M=M+1
               CO1(1,M)=COO1(1,DOMATOM(IDOM,IAT))
               CO1(2,M)=COO1(2,DOMATOM(IDOM,IAT))
               CO1(3,M)=COO1(3,DOMATOM(IDOM,IAT))
               CO2(1,M)=COO2(1,DOMATOM(IDOM,IAT))
               CO2(2,M)=COO2(2,DOMATOM(IDOM,IAT))
               CO2(3,M)=COO2(3,DOMATOM(IDOM,IAT))
20      CONTINUE
        NDOMA=M
C 
C DOMAIN B
C 
        DO 70 JORD=1,NCON(IDOM)
          JDOM=DOMCON(IDOM,JORD)
          NOCONDOM=NOCONDOM+1
C
          NDOMB=0
          M=NDOMA
          DO 40 IAT=1,DOMAT(JDOM)
                M=M+1
                NDOMB=NDOMB+1
                CO1(1,M)=COO1(1,DOMATOM(JDOM,IAT))
                CO1(2,M)=COO1(2,DOMATOM(JDOM,IAT))
                CO1(3,M)=COO1(3,DOMATOM(JDOM,IAT))
                CO2(1,M)=COO2(1,DOMATOM(JDOM,IAT))
                CO2(2,M)=COO2(2,DOMATOM(JDOM,IAT))
                CO2(3,M)=COO2(3,DOMATOM(JDOM,IAT))   	      
40        CONTINUE
          NTOT=NDOMA+NDOMB
C
C BEST FIT ALL ATOMS FROM TWO CONFORMATIONS SO THAT IT IS INDEPENDENT
C OF NUMBER OF ATOMS IN THE DOMAINS
C
          DO 100 I=1,NDOMA
                 MASS(I)=1.0/REAL(NDOMA)
100       CONTINUE
C
          DO 101 I=NDOMA+1,NTOT
                 MASS(I)=1.0/REAL(NDOMB)
101       CONTINUE
C
          CALL QTFIT(NTOT,CO1,CO2,RMSD,RC1,AC1,R,IER,MASS,Q,UNV,THETA)
C 
C RESET MASSES TO 1.0
C
          DO 102 I=1,NTOT
                 MASS(I)=1.0
102       CONTINUE
C
          CALL EXTMSF (NDOMA,MASS,CO1,CO2,VEXTMSFA,VINTMSFA,VMSFA)
C 
          CALL EXTMSF (NDOMB,MASS(NDOMA+1),CO1(1,NDOMA+1),
     &                 CO2(1,NDOMA+1),VEXTMSFB,VINTMSFB,VMSFB)
C
          VEXT=(VEXTMSFA)/NDOMA+(VEXTMSFB)/NDOMB
          VINT=(VINTMSFA)/NDOMA+(VINTMSFB)/NDOMB

          EXTINT(IDOM,JDOM)=0.0d0

          EXTINT(IDOM,JDOM)=SQRT(VEXT/VINT)
C	  
          WRITE(6,'(A,F8.3)')'ratio of interdomain to intradomain displa
     &cement:',EXTINT(IDOM,JDOM)
          IF(EXTINT(IDOM,JDOM).GE.EXTCRIT) THEN
            ONEOK=.TRUE.
            WRITE(6,*)'domain pair accepted for pair ',idom,jdom 
          ELSE
            ALLOK=.FALSE.
            WRITE(6,*)'domain pair not accepted for pair ',idom,jdom 	    
          ENDIF
C
C RESET DOMAIN A COORDINATES
C
          M=0
          DO 21 IAT=1,DOMAT(IDOM)
                M=M+1
                CO1(1,M)=COO1(1,DOMATOM(IDOM,IAT))
                CO1(2,M)=COO1(2,DOMATOM(IDOM,IAT))
                CO1(3,M)=COO1(3,DOMATOM(IDOM,IAT))
                CO2(1,M)=COO2(1,DOMATOM(IDOM,IAT))
                CO2(2,M)=COO2(2,DOMATOM(IDOM,IAT))
                CO2(3,M)=COO2(3,DOMATOM(IDOM,IAT))
21        CONTINUE
C
70      CONTINUE
80    CONTINUE
C
      IF(NOCONDOM.EQ.0) ALLOK=.FALSE. 
C

      
      RETURN
      END
C
C-------------------------------------------------------------
C
C                       
C     Copyright by Steven Hayward et al, 2006.
C     DynDom 3D version
C
C-------------------------------------------------------------
C
