C       GROUPS THE ATOMS IN TERMS OF A THREE DIMENSIONAL GRID INDEX.
C
       SUBROUTINE GRID(NATOT,MIN,MAX,COO,GRDSIZE,GCOO,IGRID,IGRIDAT,
     &                 GMIN,GMAX,GRDATMAX)
     
C
       IMPLICIT NONE
C
       include 'DynDom.param'
       
       INTEGER NATOT,IAT,GRDATMAX,GRDMIN,MIN,MAX
       INTEGER IX,IY,IZ,I,J,K,IG
       INTEGER IGRID(0:NGRIDMX,0:NGRIDMX,
     &        0:NGRIDMX)
       INTEGER GCOO(3,NUMATMX),GMIN(3),GMAX(3)
       INTEGER IGRIDAT(0:NGRIDMX,0:NGRIDMX,
     &        0:NGRIDMX,2*GRDATMX)
       INTEGER IGRIDIND(0:NGRIDMX,0:NGRIDMX,
     &        0:NGRIDMX),INDX       
       REAL*8  COO(3,NUMATMX),GRDSIZE

C=======================================
C==INITIALISING IGRID ==========	
       INDX=0
       DO 99 I=0,NGRIDMX
        DO 89 J=0,NGRIDMX
	 DO 79 K=0,NGRIDMX
	       IGRID(I,J,K)=0
	       IGRIDIND(I,J,K)=0
79       CONTINUE
89      CONTINUE
99     CONTINUE	     
C-----------------------------------------
C INITIALISE GRDMAX TO 1 AND GRDMIN TO MAX
          GRDATMAX=1
	  GRDMIN=GRDATMX  
C========================================
C===================================
C==INITIALISING GCMIN &GCMAX TO ZERO==
C===================================
       IG=0  
      DO 10 K=1,3 
         GMIN(K)=0
         GMAX(K)=0
10    CONTINUE
C====================================
	DO 1 IAT=1,NATOT            
               GCOO(1,IAT)=COO(1,IAT)/GRDSIZE
               GCOO(2,IAT)=COO(2,IAT)/GRDSIZE
               GCOO(3,IAT)=COO(3,IAT)/GRDSIZE
               IX=GCOO(1,IAT)
    	       IY=GCOO(2,IAT)
  	       IZ=GCOO(3,IAT)
C checking the exceeding grid parameter	        
c------------------------------------------------------------------------
c
          IF (IX .GT.NGRIDMX .OR. IX .LT. 0) THEN
	      WRITE(6,*)'WARNING :GRID LIMIT IN X AXIS EXCEEDED, CHANGE 
     &                  THE GRIDMX IN PARAM FILE',IX            
          END IF
C	  
          IF (IY .GT.NGRIDMX .OR. IY .LT. 0) THEN
	      WRITE(6,*)'WARNING :GRID LIMIT IN Y AXIS EXCEEDED, CHANGE
     &                   THE  GRIDMX IN PARAM FILE',IY
          END IF
C	  
	  IF (IZ .GT.NGRIDMX .OR. IZ .LT. 0) THEN
	      WRITE(6,*)'WARNING :GRID LIMIT IN Z AXIS EXCEEDED, CHANGE
     &                   THE  GRIDMX IN PARAM FILE',IZ
          END IF
C-------------------------------------------------------------------------
c determine the gmax and gmin
c----------------------------------------------------------------------	  
	  IF(IX .LT. GMIN(1))  GMIN(1)=IX
	  IF(IY .LT. GMIN(2))  GMIN(2)=IY
	  IF(IZ .LT. GMIN(3))  GMIN(3)=IZ	 
	  IF(IX .GT. GMAX(1))  GMAX(1)=IX
	  IF(IY .GT. GMAX(2))  GMAX(2)=IY
	  IF(IZ .GT. GMAX(3))  GMAX(3)=IZ	 
C--------------------------------------------------------------------------

	       IGRID(IX,IY,IZ)=IGRID(IX,IY,IZ)+1
C-------------------------------------------------------------------------
C checking the grdatmax parameter
          IF (IGRID(IX,IY,IZ) .GT. 2*GRDATMX) THEN
              WRITE(6,*)' NUMBER OF ATOMS IN A GRID CELL EXCEEDED : ',
     &                    IG,' ',IX,IY,IZ
	     STOP
	     END IF	       
C-------------------------------------------------------------------------	     
	       IG=IGRID(IX,IY,IZ)
C
          IF (IG .GT. GRDATMAX) THEN
  	       GRDATMAX=IG	       
	  END IF 
C	     
          IF (IGRID(IX,IY,IZ) .LT. 0 )THEN
              WRITE(6,*)' GRID VALUE IN NEGATIVE!!! ERROR OCCURED !!! '
  	      STOP
	  END IF
C	  
	  IF (IGRID(IX,IY,IZ) .LT. GRDMIN)THEN
 	      GRDMIN=IG
	  END IF
C	  
   	      IGRIDAT(IX,IY,IZ,IG)=IAT
C	      
1       CONTINUE  	
c
c         WRITE(6,*)' GMIN ',(GMIN(I),I=1,3)
c         WRITE(6,*)' GMAX ',(GMAX(I),I=1,3)
c	 WRITE(6,*)' MAX NO OF ATOMS IN A GRID ',GRDATMAX	 
c	 write(6,*)' min no of atoms in a grid ',grdmin
c----------------------------------------------------------
c determine the total number of grids
c---------------------------------------------------------
	 DO IX=GMIN(1),GMAX(1)
	  DO IY=GMIN(2),GMAX(2)
	   DO IZ=GMIN(3),GMAX(3)
	      INDX=INDX+1 
	      IGRIDIND(IX,IY,IZ)=INDX 
C	     IF (IGRID(IX,IY,IZ) .GT. 0)THEN 
C         WRITE(6,*)'GRD ',IX,IY,IZ,IGRID(IX,IY,IZ),GRDATMAX
C             END IF
	   END DO
	  END DO
	 END DO
C-----------------------------------------------------	  
c	 DO IAT=1,NATOT
c      WRITE(6,*)'COO ',IAT,COO(1,IAT),COO(2,IAT),COO(3,IAT),GCOO(1,IAT),
c     &GCOO(2,IAT),GCOO(3,IAT)
c	 END DO
c---------------------------------------------------------	 
c	 WRITE(6,*) ' TOTAL GRIDS ',INDX

      RETURN
      END
C
C-------------------------------------------------------------
C
C                       
C     Copyright by Steven Hayward et al., 2006.
C     DYNDOM 3D WINDOW VERSION
C
C-------------------------------------------------------------

	 
