C
C DETERMINES INTERDOMAIN SCREW-AXES OR HINGE AXES
C
      SUBROUTINE HINGEAXES2 (NDOM,NATOT,DOMAT,
     &                      DOMATOM,RESNUM,
     &                      COO1,COO2,MASS,NDOMO,NCON,DOMCON,DOMORD,
     &                      DOMCONAT,NCONAT,LCONAT,EXTINT,EXTCRIT,
     &                      ATCHAIN,DOMSIZE,IOUT1,IOUT6,IOUT7,NPAIR,
     &                      RESMAX)
C 
      IMPLICIT NONE
C 
      include 'DynDom.param'
C 
      INTEGER DOMORD(*),NDOMO,NDOM,NATOT
      INTEGER NCON(*),DOMCON(NDOMX,NDOMX)
      INTEGER KAT,JAT,RESMAX
      INTEGER I,J,M,NDOMB
      INTEGER DOMA,DOMB,DOMSIZE(*)
      INTEGER DOMAT(NDOMX),DOMATOM(NDOMX,NUMATMX)
      INTEGER DOMCONAT(NDOMX,NUMATMX),NCONAT(NDOMX)
      INTEGER IPAIR,NPAIR
      INTEGER IOUT1,IOUT6,IOUT7
      REAL*8 UNTHX,UNTHY,UNTHZ,AMPROT,AMPTR,XL,YL,ZL
      REAL*8 MASS(*),RMSD,TRACER 
      REAL*8 COO1(3,NUMATMX),COO2(3,NUMATMX)
      REAL*8 CO1(3,NUMATMX),CO2(3,NUMATMX)
      REAL*8 VEXT(3),VEXTMSF,VINTMSF,VMSF
      REAL*8 EXTINT(NDOMX,NDOMX),EXTCRIT,PERCEXT
      REAL*8 Q(4),UNV(3)
      CHARACTER*5 RESNUM(*)
      CHARACTER*1 ATCHAIN(NUMATMX) 
      LOGICAL DONEDOMA,LCONAT(NUMATMX)
C
c============================================
C INITIALISATION
C============================================ 
      IPAIR=0
      DO I=1,3
       UNV(I)=0
      END DO 
C      
      UNTHX=0.0D0
      UNTHY=0.0D0
      UNTHZ=0.0D0
C===============================================
C DETERMINING THE HINGE AXES
C----------------------------------------------
C
              WRITE(IOUT1,'(A)')'FOLLOWING IS THE RESULT OF ANALYSIS OF 
     &CONNECTED DOMAIN PAIRS FOR WHICH THE RATIO CRITERION IS SATISFIED' 
C
      DO 80 I=1,NDOMO
C
        DOMA=DOMORD(I)
        DONEDOMA=.FALSE.        
C
C DOMAINS B
C 
        DO 70 J=1,NCON(DOMA)
C
          DOMB=DOMCON(DOMA,J)
	  
         IF (DOMB .EQ. 0) GO TO 70
C
          IF(EXTINT(DOMA,DOMB).GE.EXTCRIT) THEN
  
            IF(.NOT.DONEDOMA) THEN
C
              IF(DOMA.GT.26) THEN
                WRITE(6,'(A)')'WARNING COLOURS WILL NOT BE UNIQUE'
              ENDIF
C
              WRITE (IOUT1,'(A80)') '===================================
     &============================================='
              WRITE(IOUT1,'(A)')'FIXED  DOMAIN'
              WRITE(IOUT1,'(A,I3)')'DOMAIN NUMBER: ',DOMA
              WRITE(IOUT1,'(A,I6,A)')'SIZE: ',DOMSIZE(DOMA),' ATOMS'
C-------------------------------------------------------------------------
C FIT DOMAIN A OF CONFORMATION 2 TO DOMAIN A OF CONFORMATION 1 RELOCATING
C WHOLE OF CONFORMATION 2 ACCORDINGLY
C------------------------------------------------------------------------
           CALL FITDOM(NATOT,DOMA,DOMAT,DOMATOM,COO1,COO2,MASS,RMSD)
C--------------------------------------------------------------------------
C
              WRITE (IOUT1,'(A,F8.3,A)') 'ALLATOM RMSD ON THIS DOMAIN: 
     &',RMSD,'A'
C
              DONEDOMA=.TRUE.
C
            ENDIF
C
C END OF OUTPUT FOR DOMAIN A
C
            IF(DOMB.GT.26) THEN
              WRITE(6,'(A)')'WARNING COLOURS WILL NOT BE UNIQUE'
            ENDIF
C
            IPAIR=IPAIR+1
C
            IF(IPAIR.GT.NPAIRMX) THEN
              WRITE(6,'(A,I4,I4)')'ARRAY BOUNDARY FOR NUMBER OF PAIRS HA
     &S BEEN EXCEEDED: ',NPAIRMX,IPAIR
              WRITE(6,'(A)')'CHANGE VALUE FOR "NPAIRMX" IN "DynDom.param
     &"'
              STOP
            ENDIF
C
            WRITE (IOUT1,'(A80)') '-------------------------------------
     &-------------------------------------------'
C
            IF(IPAIR.EQ.1.OR.IPAIR.EQ.21.OR.IPAIR.EQ.31) THEN
              WRITE(IOUT1,'(A,I3,A)')'MOVING DOMAIN (RELATIVE TO FIXED D
     &OMAIN), ',IPAIR,'ST PAIR' 
               WRITE(IOUT1,'(A,I3)')'DOMAIN NUMBER: ',DOMB
            ELSEIF(IPAIR.EQ.2.OR.IPAIR.EQ.22.OR.IPAIR.EQ.32) THEN
              WRITE(IOUT1,'(A,I3,A)')'MOVING DOMAIN (RELATIVE TO FIXED D
     &OMAIN), ',IPAIR,'ND PAIR' 
              WRITE(IOUT1,'(A,I3)')'DOMAIN NUMBER: ',DOMB     
            ELSEIF(IPAIR.EQ.3.OR.IPAIR.EQ.23.OR.IPAIR.EQ.33) THEN
              WRITE(IOUT1,'(A,I3,A)')'MOVING DOMAIN (RELATIVE TO FIXED D
     &OMAIN), ',IPAIR,'RD PAIR' 
              WRITE(IOUT1,'(A,I3)')'DOMAIN NUMBER: ',DOMB     
            ELSE 
              WRITE(IOUT1,'(A,I3,A)')'MOVING DOMAIN (RELATIVE TO FIXED D
     &OMAIN), ',IPAIR,'TH PAIR' 
               WRITE(IOUT1,'(A,I3)')'DOMAIN NUMBER: ',DOMB
C
            ENDIF
C
            WRITE(IOUT1,'(A,I6,A)')'SIZE: ',DOMSIZE(DOMB),' ATOMS'
C
            M=0
            DO 40 JAT=1,DOMAT(DOMB)
              KAT=DOMATOM(DOMB,JAT)
              M=M+1
              CO1(1,M)=COO1(1,KAT)
              CO1(2,M)=COO1(2,KAT)
              CO1(3,M)=COO1(3,KAT)
              CO2(1,M)=COO2(1,KAT)
              CO2(2,M)=COO2(2,KAT)
              CO2(3,M)=COO2(3,KAT)              
40          CONTINUE
            NDOMB=M
C------------------------------------------------------------------------- 
C CALL SUBROUTINE TO DETERMINE EXTERNAL COMPONENT TO MOTION OF DOMAIN
C B IN CONFORMATION 1 TO DOMAIN B IN CONFORMATION 2
C------------------------------------------------------------------------
            CALL ROTCOMP(NDOMB,MASS,VEXT,VEXTMSF,VINTMSF,VMSF,TRACER
     &                   ,CO1,CO2,RMSD,Q,UNV,AMPROT)
C 
            UNTHX=UNV(1)
	    UNTHY=UNV(2)
	    UNTHZ=UNV(3)
C------------------------------------------------------------------------
            WRITE (IOUT1,'(A,F8.3,A)') 'ALLATOM RMSD ON THIS DOMAIN: ',
     &RMSD,'A'
            WRITE(IOUT1,'(A)') 
            WRITE(IOUT1,'(A,F8.3)')'RATIO INTERDOMAIN TO INTRADOMAIN DIS
     &PLACEMENT: ',EXTINT(DOMA,DOMB)
            PERCEXT=VEXTMSF*100.0/VMSF
            IF(PERCEXT.GT.100.0) PERCEXT=100.0
C----------------------------------------------------------- 
C CALL ROUTINE TO LOCATE SCREW AXIS
C ----------------------------------------------------------
C
            CALL SCREWAX(NDOMB,CO1,VEXT,AMPROT,
     &                     UNTHX,UNTHY,UNTHZ,AMPTR,XL,YL,ZL)
C-------------------------------------------------------------
            AMPROT=AMPROT*180.0/PI
C
            WRITE (IOUT1,'(A18,F8.3,A8)') 'ANGLE OF ROTATION:',
     &     AMPROT,' DEGREES'
C     
            WRITE (IOUT1,'(A23,F8.3,A2)') 'TRANSLATION ALONG AXIS:',
     &     AMPTR,' A'
C ----------------------------------------------------------------
C CALL ROUTINE TO FIND ATOMS NEAR AXIS
C ----------------------------------------------------------------
C
            CALL AXRES(NATOT,DOMA,DOMB,UNTHX,
     &                 UNTHY,UNTHZ,XL,YL,ZL,COO1,DOMCONAT,NCONAT,
     &                 LCONAT,IOUT1)
C------------------------------------------------------------------- 
C CALL ROUTINE TO DETERMINE DEGREE OF CLOSURE MOTION
C---------------------------------------------------------------------
            CALL CLOSURE(DOMA,DOMB,COO1,UNTHX,UNTHY,UNTHZ,XL,YL,ZL
     &                   ,IOUT1,DOMATOM,DOMAT,DOMCONAT,NCONAT)
C -------------------------------------------------------------------
C CALL ROUTINE TO WRITE OUT SCREW AXIS AND SCRIPT FOR DISPLAY ON RASMOL
C----------------------------------------------------------------------
            CALL ARROW(DOMA,DOMB,NATOT,COO1,UNTHX,UNTHY,UNTHZ,
     &     XL,YL,ZL,RESNUM,IPAIR,ATCHAIN,IOUT6,RESMAX)
C------------------------------------------------------------------------
          ENDIF
C	  
70      CONTINUE
C
80    CONTINUE
C     
        NPAIR=IPAIR
c
      RETURN
C      
      END
C-------------------------------------------------------------
C
C                       
C     Copyright by Steven Hayward et al, 2006.
C     DynDom Version 1.5 with Quaternion best fit
C
C-------------------------------------------------------------
C
