C  DETERMINE PAIRWISE LOCALLY CONNECTED SETS INTO A GLOBAL CONNECTED 
C  SETS 
C   THIS SUBROUTINE USES THE TECHNIQUE FOLLOWED
C  IN CONNECTED SET ALGORTIHM WHICH IS KINDLY PROVIDED BY 
C  DR.FRED VELLIEUX  (VELLIEUX@IBS.FR) 
C REFERENCE :  ACTA CRYSTALLOGR D BIOL CRYSTALLOGR. 1997 JUL 1;53(PT 4):434-7
C
       SUBROUTINE PARSECONNLIST(CONNLIST,NCONNS,GLOBSET,NCS,NSET,GSET,
     &                          NSUBSETS,PARSEOK)
C
       IMPLICIT NONE
C
       include 'DynDom.param'
C
      INTEGER      NCONNS,NCS,NSUBSETS
      INTEGER      CONNLIST(2,NCONNS)
      INTEGER      NSET(NLOCSETMX),GLOBSET(NGLOBSETMX,NLOCSETMX)
      INTEGER      CUR_ROOT,AS_2,I,J,GSET(NLOCSETMX)
      LOGICAL      LESS_THAN,CHANGED,PARSEOK
      REAL*8       T1,T2 
C
C  INITIALIZE APPROPRIATE VARIABLES TO ZERO, INCLUDING CUR_ROOT -- THIS
C  VARIABLE REPRESENTS THE CURRENT ANCHOR SET WHICH IS DEFINED AS THE
C  FIRST ELEMENT IN THE CURRENT CONNECTED SET.  FINALLY, IF THERE IS
C  MORE THAN ONE ROW IN THE CONNECTION_LIST, QUICK-SORT THE LIST.  NOTE
C  THAT BECAUSE OF THE PROCEDURE USED TO FORM THE CONNECTION_LIST, ALL
C  LINES IN THE LIST SHOULD BE UNIQUE.
C
c      NCS=0
      PARSEOK=.TRUE.
      NSUBSETS=0
      CUR_ROOT=0
      I=NCONNS
        CALL CPU_TIME(T1)
C	
C CALL QSORT MATRIX INITIALISATION'
C
      IF (I.GE.2) THEN
         CALL QSORTMAT(CONNLIST,I,NCONNS)
      END IF
C
        CALL CPU_TIME(T2)
C      write(6,*) 'time taken to qsort mat ',T2-T1
C
C  CHECK THE FIRST ELEMENT IN THE LIST (I.E. THE (1,1) POSITION) TO SEE  
C  IF THE LOWEST SET NUMBER IN THE LIST HAS CHANGED, WHICH WOULD INDICATE
C  A NEW CONNECTED SET HAS STARTED.  NEXT, ADD THE SUBSET IN THE (1,2) 
C  POSITION TO THE CORRECT CONNECTED SET, AND INCREMENT THE APPROPRIATE 
C  COUNTERS.  NOTE THAT THE LOGIC OF THIS ALGORITHM REQUIRES THAT 
C  CONNLIST(1,1) MUST BE AT ALL TIMES THE NUMERICALLY LOWEST 
C  SET APPEARING ANYWHERE IN THE CONNECTION_LIST!  SUBSTITUTE ALL
C  OCURRENCES OF SET (1,2) WITH THE VALUE OF (1,1) AFTER PURGING ROW
C  1 FROM THE LIST.  FINALLY, QUICK-SORT THE SUBSTITUTED LIST AND
C  PURGE REDUNDANCIES BEFORE LOOPING BACK TO THE START.
C
        CALL CPU_TIME(T1)

      DO WHILE (I.GE.1)
         IF (CONNLIST(1,1).NE.CUR_ROOT) THEN
            CUR_ROOT=CONNLIST(1,1)
            NCS=NCS+1
	    IF (NCS .GE. NGLOBSETMX ) THEN
	     WRITE(6,*)'LIMIT FOR GLOBAL SETS HAVE EXCEEDED. ALTER YOUR 
     &PARAMETER ACCORDINGLY'
  	     WRITE(6,*)' CHANGE THE NGLOBSETMX PARAMETER '		 
	     WRITE(6,*)' RETURNING FROM  PARSING CONNECTION LIST ROUTINE '
	     PARSEOK=.FALSE.
	     go to 9990  
	    END IF
            NSET(NCS)=1
            NSUBSETS=NSUBSETS+1
            GLOBSET(1,NSET(NCS))=CUR_ROOT
	    GSET(CUR_ROOT)=NCS
         END IF
         AS_2=CONNLIST(2,1)
         NSET(NCS)=NSET(NCS)+1
	 IF (NSET(NCS) .GT. NLOCSETMX ) THEN
	  WRITE(6,*)'WARNING : NUMBER OF CONNECTED LOCALSETS HAS REACHED 
     &MAXIMUM. ALTER YOUR NLOCSETMX PARAMETER ACCORDINGLY'
 	  WRITE(6,*)' CHANGE THE NLOCSETMX PARAMETER '		 
  	  WRITE(6,*)' RETURNING FROM  PARSING CONNECTION LIST ROUTINE '
	  PARSEOK=.FALSE.     
          go to 9990
	 END IF
         NSUBSETS=NSUBSETS+1
C         CNCTD_SET_TABLE(NSET(NCS),NCS)=AS_2
         GLOBSET(NCS,NSET(NCS))=AS_2
	 GSET(AS_2)=NCS
         I=I-1
         DO J=1,I
            CONNLIST(1,J)=CONNLIST(1,J+1)
            CONNLIST(2,J)=CONNLIST(2,J+1)
         END DO
C
C  REMEMBER, CUR_ROOT SHOULD BE LOWEST THE VALUE IN THE TABLE !
C
         IF (I.GE.1) THEN
            LESS_THAN=.TRUE.
            CHANGED=.FALSE.
            J=0
            DO WHILE ((LESS_THAN).AND.(J.LT.I))
               J=J+1
               IF (CONNLIST(1,J).GT.AS_2) THEN
                  LESS_THAN=.FALSE.
               ELSE IF (CONNLIST(1,J).EQ.AS_2) THEN
                  CONNLIST(1,J)=CUR_ROOT
                  CHANGED=.TRUE.
               ELSE IF (CONNLIST(2,J).EQ.AS_2) THEN
                  CONNLIST(2,J)=CONNLIST(1,J)
                  CONNLIST(1,J)=CUR_ROOT
                  CHANGED=.TRUE.
               END IF
            END DO
         END IF
         IF ((CHANGED).AND.(I.GE.2)) THEN
            CALL QSORTMAT(CONNLIST,J,NCONNS)
            CALL UNIQUE(CONNLIST,I,NCONNS)
         END IF
      END DO
      CALL CPU_TIME(T2)
C      WRITE(6,*) 'TIME TAKEN TO PARSE ',T2-T1      
C
 9990 CONTINUE
      RETURN
      END     
C-------------------------------------------------------------
C PARSING CONNECTION LIST
C-------------------------------------------------------------
      
       
       
