C
C ROUTINE TO ORIENT ALONG THE PRINCIPAL AXIS COORDINATE
C 
      SUBROUTINE PRINAX(NATOT,COO,COOPRIN)
C 
      IMPLICIT NONE
C
      include 'DynDom.param'
C           
C 
       INTEGER NATOT,I,J,k,ier                                                                      
       REAL*8 COO(3,NUMATMX),COOPRIN(3,NUMATMX)                                       
       REAL*8 INTEN(3,3),E(3),W1(3),XCM,YCM,ZCM,DETER
       REAL*8 VEC(3,3),W2(3),XTERM,YTERM,ZTERM
C---------------------
C INTIALISATION
C----------------------
         XCM=0.0
         YCM=0.0
         ZCM=0.0
C
       DO I=1,3
        DO J=1,3	
	   INTEN(I,J)=0.0D0
	   VEC(I,J)=0.0D0	    
	END DO	 
       END DO 	
C---------------------------       
C  FIND THE CENTRE OF MASS         
C----------------------------
       DO 2 I=1,NATOT
         XCM=XCM+COO(1,I)
         YCM=YCM+COO(2,I)
         ZCM=ZCM+COO(3,I)
2      CONTINUE
C----------------------------
C AVERAGE
C--------------------------
       XCM=XCM/NATOT
       YCM=YCM/NATOT
       ZCM=ZCM/NATOT
C---------------------------------------       
C SUBTRACT THE COORD FROM CENTRE OF MASS
C----------------------------------------
       DO 4 I=1,NATOT
         COO(1,I)=COO(1,I)-XCM
         COO(2,I)=COO(2,I)-YCM
         COO(3,I)=COO(3,I)-ZCM
4      CONTINUE
C-------------------------------
C DETERMINE THE INERTIA TENSOR
C-------------------------------
       DO 3 I=1,NATOT
          INTEN(1,1)=INTEN(1,1)+(COO(2,I)**2+COO(3,I)**2)  
          INTEN(2,2)=INTEN(2,2)+(COO(1,I)**2+COO(3,I)**2)  
          INTEN(3,3)=INTEN(3,3)+(COO(1,I)**2+COO(2,I)**2)  
          INTEN(2,1)=INTEN(2,1)-COO(1,I)*COO(2,I)
          INTEN(3,1)=INTEN(3,1)-COO(1,I)*COO(3,I)
          INTEN(3,2)=INTEN(3,2)-COO(2,I)*COO(3,I)
3      CONTINUE
C-------------------------------------------
C AVERAGE IT
C-----------------------------------------
        INTEN(1,1)=INTEN(1,1)/NATOT
        INTEN(2,2)=INTEN(2,2)/NATOT
        INTEN(3,3)=INTEN(3,3)/NATOT
        INTEN(2,1)=INTEN(2,1)/NATOT
        INTEN(3,1)=INTEN(3,1)/NATOT
        INTEN(3,2)=INTEN(3,2)/NATOT 
c-------------------------------------------	
c fill the symmeTric parts of the matrix
c--------------------------------------------
        INTEN(1,2)=INTEN(2,1)
	INTEN(1,3)=INTEN(3,1)
	INTEN(2,3)=INTEN(3,2)          
C
C CALLING DIAGONALIZTION ROUTINE
C
        CALL JACOBI (3,3,INTEN,E,VEC,W1,W2,IER)
c----------------------------------------------------
C select the direction for each principal moment axis 
c-------------------------------------------------------
       DETER=0.0D0 
       DO I=1,2
         DO J=1,NATOT
	  DETER=(VEC(1,I)*COO(1,J))+(VEC(2,I)*COO(2,J))+
     &          (VEC(3,I)*COO(3,J))
           IF (DETER .GT. 0.0D0) THEN
	    DO K=1,3
	      VEC(K,I)=-VEC(K,I)
	    END DO
	   END IF
	   IF (DETER .NE. 0.0D0) GO TO 100             	  
         END DO 
100     CONTINUE	 
       END DO   
c---------------------------------------------------------
C CHECK FOR PRESERVING THE ORIENTATION (RIGHT HANDEDNESS)
C--------------------------------------------------------
C
          DETER=0.0D0       
          XTERM=VEC(1,1)* (VEC(2,2)*VEC(3,3) -VEC(2,3)*VEC(3,2)) 
          YTERM=VEC(2,1)* (VEC(1,3)*VEC(3,2) -VEC(1,2)*VEC(3,3))
          ZTERM=VEC(3,1)* (VEC(1,2)*VEC(2,3) -VEC(1,3)*VEC(2,2))
	  DETER= XTERM+YTERM+ZTERM 	            
       	 IF (DETER .LT.0) THEN
	       DO I=1,3
                 VEC(I,3)=-VEC(I,3)
       	   ENDDO  
         ENDIF
C-------------------------------	 
C NOW TRANSFORM COORDINATES         
C-------------------------------
        DO 7 I=1,NATOT
          COOPRIN(1,I)=VEC(1,1)*COO(1,I)+VEC(2,1)*COO(2,I)
     &+VEC(3,1)*COO(3,I)
          COOPRIN(2,I)=VEC(1,2)*COO(1,I)+VEC(2,2)*COO(2,I)
     &+VEC(3,2)*COO(3,I)
          COOPRIN(3,I)=VEC(1,3)*COO(1,I)+VEC(2,3)*COO(2,I)
     &+VEC(3,3)*COO(3,I)
7       CONTINUE      
C===========================================
C RETURNING COORDINATE TO ORIGINAL POSITION
c===========================================
       DO 44 I=1,NATOT
         COO(1,I)=COO(1,I)+XCM
         COO(2,I)=COO(2,I)+YCM
         COO(3,I)=COO(3,I)+ZCM
44       CONTINUE
C  
        RETURN
        END
