C
C     FOR BEST FIT USING QUATERNION ALGORITHM   partially adapted from
C     TINKER MOLECULAR MODELING PROGRAM   
C  
C     Reference: S. K. Kearsley, "On the Orthogonal Transformation 
C     Used for Structural Comparisons", Acta Crystallographica Section A
c     45, 208-210 (1989)
C
      SUBROUTINE QTFIT (N,CO1,CO2,RMSD,XC1,XC2,R,IER,MASS,Q,UNV,THETA)
        
      IMPLICIT NONE
      include 'DynDom.param'
C
      REAL*8 R(3,*),Q(4),QUAT(4,4),UNV(3),THETA
      REAL*8 WORK1(4),WORK2(4),CR(4,4),EV(4)
      REAL*8 XROT,YROT,ZROT
      REAL*8 XXYX,XXYY,XXYZ
      REAL*8 XYYX,XYYY,XYYZ
      REAL*8 XZYX,XZYY,XZYZ
      REAL*8 CO1(3,*),CO2(3,*)
      REAL*8 XC1(*), XC2(*)
      REAL*8 MASS(*),MASSTOT,RMSD,DELTA
      INTEGER I,J,K,N,NA,II,I1,IER


C==================================
C INTIALISATION RMSD, MASSTOT,SUM
       RMSD=0.                                         
      MASSTOT=0.D0
      DO 10 K=1,3
            XC1(K)=0.
            XC2(K)=0.
10    CONTINUE 
C==================================
C INITIALISATION QUATERNION MATRIX
      DO I=1,4                                                          
         DO J=1,4                                                       
            QUAT(I,J)=0                                                
         END DO                                                         
      END DO
C====================================================
C INITIALISATION UPPER TRIANGLE OF QUATERNION MATRIX.
      XXYX = 0.0D0
      XXYY = 0.0D0
      XXYZ = 0.0D0
      XYYX = 0.0D0
      XYYY = 0.0D0
      XYYZ = 0.0D0
      XZYX = 0.0D0
      XZYY = 0.0D0
      XZYZ = 0.0D0
C=========================================
C SUMMING UP COORDINATE VALUES
      DO 30 NA=1,N
        DO 20 K=1,3
              XC1(K)=XC1(K)+CO1(K,NA)*MASS(NA)
              XC2(K)=XC2(K)+CO2(K,NA)*MASS(NA)
20      CONTINUE
30    CONTINUE  
C==========================================
C  MASS SUM
      DO 40 II=1,N
            MASSTOT=MASSTOT+MASS(II)
40    CONTINUE
C===========================================
C MASS AVERAGE
      DO 50 K=1,3
            XC1(K)=XC1(K)/MASSTOT
            XC2(K)=XC2(K)/MASSTOT
50    CONTINUE
C============================================
C    CREATIING COORDINATE DIFFERENCES
      DO 70 NA=1,N
        DO 60 K=1,3
              CO1(K,NA)=CO1(K,NA)-XC1(K)
              CO2(K,NA)=CO2(K,NA)-XC2(K)
60      CONTINUE
70    CONTINUE
C======================================================
C BUILDING THE UPPER TRIANGLE OF THE QUATERNION MATRIX.
      DO I = 1, N
             XXYX = XXYX + MASS(I)*CO1(1,I)*CO2(1,I)
             XXYY = XXYY + MASS(I)*CO1(2,I)*CO2(1,I)
             XXYZ = XXYZ + MASS(I)*CO1(3,I)*CO2(1,I)
             XYYX = XYYX + MASS(I)*CO1(1,I)*CO2(2,I)
             XYYY = XYYY + MASS(I)*CO1(2,I)*CO2(2,I)
             XYYZ = XYYZ + MASS(I)*CO1(3,I)*CO2(2,I)
             XZYX = XZYX + MASS(I)*CO1(1,I)*CO2(3,I)
             XZYY = XZYY + MASS(I)*CO1(2,I)*CO2(3,I)
             XZYZ = XZYZ + MASS(I)*CO1(3,I)*CO2(3,I)
      END DO
      
             CR(1,1) = XXYX + XYYY + XZYZ
	     CR(1,2) = -XZYY + XYYZ
	     CR(2,2) = XXYX - XYYY - XZYZ
	     CR(1,3) = -XXYZ + XZYX
	     CR(2,3) = XXYY + XYYX
	     CR(3,3) = XYYY - XZYZ - XXYX
	     CR(1,4) = -XYYX + XXYY
	     CR(2,4) = XZYX + XXYZ
	     CR(3,4) = XYYZ + XZYY
	     CR(4,4) = XZYZ - XXYX - XYYY
C====================================================
C
C     DIAGONALIZING THE QUATERNION MATRIX USING JACOBI
C
      CALL JACOBI (4,4,CR,EV,QUAT,WORK1,WORK2,IER)
C=====================================================
c-- TO change the orienation check the eigen values and 
c   give the approproiate  conditions
c------------------------------------------------------
C     EXTRACT THE QUATERNION
C
	      Q(1) = QUAT(1,4)
	      Q(2) = QUAT(2,4)
	      Q(3) = QUAT(3,4)
	      Q(4) = QUAT(4,4)
      
C=============================================================      
C
C     ASSEMBLE ROTATION MATRIX THAT SUPERIMPOSES THE MOLECULES
C
	      R(1,1) = Q(1)**2 + Q(2)**2 - Q(3)**2 - Q(4)**2
	      R(2,1) = 2.0D0 * (Q(2) * Q(3) + Q(1) * Q(4))
	      R(3,1) = 2.0D0 * (Q(2) * Q(4) - Q(1) * Q(3))
	      R(1,2) = 2.0D0 * (Q(3) * Q(2) - Q(1) * Q(4))
	      R(2,2) = Q(1)**2 - Q(2)**2 + Q(3)**2 - Q(4)**2
	      R(3,2) = 2.0D0 * (Q(3) * Q(4) + Q(1) * Q(2))
	      R(1,3) = 2.0D0 * (Q(4) * Q(2) + Q(1) * Q(3))
	      R(2,3) = 2.0D0 * (Q(4) * Q(3) - Q(1) * Q(2))
	      R(3,3) = Q(1)**2 - Q(2)**2 - Q(3)**2 + Q(4)**2
      
C===========================================================
C     ROTATE (SHIFT) SECOND MOLECULE TO BEST FIT WITH FIRST MOLECULE
C

      DO I = 1, N
             XROT = CO2(1,I)*R(1,1) + CO2(2,I)*R(1,2) + CO2(3,I)*R(1,3)
             YROT = CO2(1,I)*R(2,1) + CO2(2,I)*R(2,2) + CO2(3,I)*R(2,3)
             ZROT = CO2(1,I)*R(3,1) + CO2(2,I)*R(3,2) + CO2(3,I)*R(3,3)
             CO2(1,I) = XROT
             CO2(2,I) = YROT
             CO2(3,I) = ZROT
      END DO
C========================================================      
C FOR RMSD
      DO 170 NA=1,N
        DO 160 I1=1,3
               DELTA=CO2(I1,NA)-CO1(I1,NA)
               RMSD=RMSD+DELTA*DELTA
160     CONTINUE
170   CONTINUE

	       RMSD=SQRT(RMSD/N)
C=====================================================
C CALCULATING THETA AND UNIVEC              

	       THETA=2*ACOS(Q(1))
               UNV(1)=(Q(2)/(SIN(THETA/2)))
	       UNV(2)=(Q(3)/(SIN(THETA/2)))
               UNV(3)=(Q(4)/(SIN(THETA/2)))
      
      IF (THETA .GT. PI) THEN
      	  THETA = 2* PI - THETA
          UNV(1)=-(Q(2)/(SIN(THETA/2)))
          UNV(2)=-(Q(3)/(SIN(THETA/2)))
          UNV(3)=-(Q(4)/(SIN(THETA/2)))
      END IF
C=====================================================      
      RETURN
      END
      
C
C-------------------------------------------------------------
C
C                       
C     Copyright by Steven Hayward et al, 2006.
C     DynDom Version 1.5 with Quaternion best fit
C
C-------------------------------------------------------------
C
      
