C 
C SUBROUTINE TO CALCULATE EXTERNAL COMPONENT TO DISPLACEMENT
C 
      SUBROUTINE ROTCOMP(N,MASS,VEXT,VEXTMSF,VINTMSF,VMSF,TRACER
     &                   ,CO1,CO2,RMSD,Q,UNV,THETA)
C 
      IMPLICIT NONE
C
      include 'DynDom.param'
C 
      INTEGER I,N,IER
      REAL*8 MASS(*),R(3,3),RC1(3),RC2(3),RMSD
      REAL*8 CO1(3,*),CO2(3,*),COSAV(3,NUMATMX)
      REAL*8 VEXT(*),VEXTX,VEXTY,VEXTZ,VEXTMSF
      REAL*8 VINTMSF,TRACER
      REAL*8 VX,VY,VZ,VMSF
      REAL*8 Q(4),UNV(3),THETA
C------------------------------------------------------------------- 
      VMSF=0.0D0
      UNV(1)=0.0D0
      UNV(2)=0.0D0
      UNV(3)=0.0D0            
C--------------------------------------------------------------------      
C
      DO 8 I=1,N
        VX=CO2(1,I)-CO1(1,I)
        VY=CO2(2,I)-CO1(2,I)
        VZ=CO2(3,I)-CO1(3,I)
        VMSF=VMSF+(VX**2+VY**2+VZ**2)
8     CONTINUE
C-----------------------------------------------------------------------
      DO 10 I=1,N
        COSAV(1,I)=CO1(1,I)
        COSAV(2,I)=CO1(2,I)
        COSAV(3,I)=CO1(3,I)
10    CONTINUE
C-------------------------------------------------------------------- 
      CALL QTFIT(N,CO2,CO1,RMSD,RC2,RC1,R,IER,MASS,Q,UNV,THETA)
C-------------------------------------------------------------------
C
 	     TRACER=R(1,1)+R(2,2)+R(3,3)
	     VINTMSF=(RMSD**2)*N
C
	     VEXTMSF=0.0D0
C--------------------------------------------------------------------	     
      DO 9 I=1,N
             CO2(1,I)=CO2(1,I)+RC2(1)
             CO2(2,I)=CO2(2,I)+RC2(2)
             CO2(3,I)=CO2(3,I)+RC2(3)
             VEXTX=CO1(1,I)-COSAV(1,I)+RC2(1)
             VEXTY=CO1(2,I)-COSAV(2,I)+RC2(2)
             VEXTZ=CO1(3,I)-COSAV(3,I)+RC2(3)
             VEXTMSF=VEXTMSF+(VEXTX**2+VEXTY**2+VEXTZ**2)
9     CONTINUE
C-----------------------------------------------------------
C DETERMINE EXTERNAL CONTRIBUTION TO CONFORMATIONAL CHANGE
C------------------------------------------------------------
C
      DO I=1,3
        VEXT(I)=0
      END DO
C------------------------------------------------------------
       VEXT(1*3-2)=(CO1(1,N)-COSAV(1,N)+RC2(1))
       VEXT(1*3-1)=(CO1(2,N)-COSAV(2,N)+RC2(2))
       VEXT(1*3  )=(CO1(3,N)-COSAV(3,N)+RC2(3))
C-------------------------------------------------------------
C 
      DO 30 I=1,N
        CO1(1,I)=COSAV(1,I)
        CO1(2,I)=COSAV(2,I)
        CO1(3,I)=COSAV(3,I)
30    CONTINUE
C 
      RETURN
C      
      END
C
C-------------------------------------------------------------
C
C                       
C     Copyright by Steven Hayward et al, 2006.
C     DynDom Version 1.5 with Quaternion best fit
C
C-------------------------------------------------------------
C
