C VOTING THE ATOMS ACCORDING TO PRESENCE IN THE CLUSTERS

         SUBROUTINE VOTE(NATOT,DOMIN,COO,IGRID,
     &                   IGRIDAT,GMAX,GRDSIZE,NCLUS,IWORK,ATBL,
     &                   ATBLK,IVOTE,ATCLUS,CLUSATOM,CLUSAT,INCLUS,
     &                   CLUSCOUNT,VOTEOK)   
         
      IMPLICIT NONE
      include 'DynDom.param'
               
      INTEGER NATOT,IAT,IVOTE(NUMATMX),NCLUS,ICLUS,I1
      INTEGER ATBL(NUMATMX),ATBLK(NUMATMX,500),IWORK(NBLOCKMX)
      INTEGER BL
      INTEGER CLUSVOTE(NUMATMX,NCLUSMX),CLUSAT(NCLUSMX)
      INTEGER ATCLUS(NUMATMX),CLUSATOM(NCLUSMX,NUMATMX)
      INTEGER NEWCLUS(NUMATMX),JAT,IX,IY,IZ,I,J,K,NONCLUS,BLKAT,IK
      INTEGER CLUSCOUNT(NUMATMX),INCLUS(NUMATMX,NCLUSMX)
      INTEGER GMAX(3),DOMIN
      INTEGER IGRID(0:NGRIDMX,0:NGRIDMX,
     &        0:NGRIDMX)
      INTEGER IGRIDAT(0:NGRIDMX,0:NGRIDMX,
     &        0:NGRIDMX,2*GRDATMX)
      REAL*8  COO(3,NUMATMX),GRDSIZE    
      LOGICAL LVOTE(NUMATMX),VOTEOK       
C----------------------------------------------------------------    
C VOTING FOR EACH ITERATION IN CLUSTERIMG FOR INTERCLUSTER ATOMS
C==========================================
C INITIALISATION
C------------------------------------------
        VOTEOK=.TRUE. 
C	
        DO IAT=1,NATOT
           IVOTE(IAT)=0
           LVOTE(IAT)=.FALSE.
           CLUSCOUNT(IAT)=0
           NEWCLUS(IAT)=0
C	   
         DO ICLUS=1,NCLUS
            CLUSVOTE(IAT,ICLUS)=1
            INCLUS(IAT,ICLUS)=0
         END DO
C	 
        END DO 
C	
        DO ICLUS=1,NCLUS
           CLUSAT(ICLUS)=0
        END DO
C============================================
C ASSIGN THE CLUSTER WEIGHTS TO ATOMS
C-------------------------------------------
       DO IAT=1,NATOT
         IF (ATBL(IAT) .GE. 1) THEN
          DO I1=1,ATBL(IAT)
             CLUSVOTE(IAT,IWORK(ATBLK(IAT,I1)))=
     &       CLUSVOTE(IAT,IWORK(ATBLK(IAT,I1)))+1
          END DO
         END IF
       END DO 
C---------------------------------------------------
C EACH ATOM GETS THE VOTE      
C--------------------------------------------------
       DO IAT=1,NATOT
        DO ICLUS=1,NCLUS
           IVOTE(IAT)=MAX(CLUSVOTE(IAT,ICLUS),IVOTE(IAT))
        END DO        
       END DO 
C----------------------------------------------------------
C ASSIGN FOR ATOM TO CLUSTER.                       
C----------------------------------------------------------       
       DO IAT=1,NATOT
        DO ICLUS=1,NCLUS        
	
         IF (IVOTE(IAT) .EQ. CLUSVOTE(IAT,ICLUS)) THEN
             LVOTE(IAT)=.TRUE.                    
             ATCLUS(IAT)=ICLUS
         END IF
         
         IF (LVOTE(IAT) ) THEN          
             CLUSCOUNT(IAT)=CLUSCOUNT(IAT)+1
             LVOTE(IAT)=.FALSE.
             INCLUS(IAT,CLUSCOUNT(IAT))=ICLUS
         END IF
	 
        END DO
       END DO      
C-------------------------------------------------------------
C LOOK AROUND FOR THE ATOMS NEAR BY WHICH ARE IN SAME CLUSTER       
C-----------------------------------------------------------------
       DO IAT=1,NATOT
          BLKAT=0
          NONCLUS=0
          BL=1  
          IX=COO(1,IAT)/GRDSIZE
          IY=COO(2,IAT)/GRDSIZE
          IZ=COO(3,IAT)/GRDSIZE               
C	  
         DO I=IX-BL,IX+BL
          DO J=IY-BL,IY+BL
           DO K=IZ-BL,IZ+BL
	      IF (I .LT. 0 .OR. I .GT. GMAX(1)) GOTO 301
	      IF (J .LT. 0 .OR. J .GT. GMAX(2)) GOTO 301
	      IF (K .LT. 0 .OR. K .GT. GMAX(3)) GOTO 301 
	      IF (IGRID(I,J,K) .EQ. 0 ) GO TO 301
              DO IK=1,IGRID(I,J,K)
                 JAT=IGRIDAT(I,J,K,IK)
                 NEWCLUS(IAT)=ATCLUS(JAT)
               IF (IAT .NE. JAT ) THEN  
                IF (ATCLUS(IAT).NE. ATCLUS(JAT)) THEN                    
                    NONCLUS=NONCLUS+1                    
                END IF
               END IF 
              END DO    
                   BLKAT=BLKAT+IGRID(I,J,K)
301         CONTINUE		   
           END DO
          END DO
         END DO
	 
         IF (100*NONCLUS/BLKAT .GE. 70 ) THEN
             ATCLUS(IAT)=NEWCLUS(IAT)
         END IF 
	 
       END DO
C===================================================       
C NOW ASSIGN THE CLUSTER VALUE FOR THE ATOMS
C----------------------------------------------------
       DO IAT=1,NATOT
        CLUSAT(ATCLUS(IAT))=CLUSAT(ATCLUS(IAT))+1
        CLUSATOM(ATCLUS(IAT),CLUSAT(ATCLUS(IAT)))=IAT
       END DO
C---------------------------------------------------------------------       
C      WRITE(6,*)'ATOMS ',(CLUSAT(ICLUS),ICLUS=1,NCLUS),' FOR ',NCLUS
C     &,' CLUSTERS'
C----------------------------------------------------------------------     
      DO ICLUS=1,NCLUS
       IF (CLUSAT(ICLUS) .LT. DOMIN ) THEN
C           WRITE(6,*)'WARNING : VOTING YIELDS ZERO ATOMS '
	   VOTEOK=.FALSE.
           RETURN
       END IF
      END DO 
C======================================================================      
      RETURN
      END
C
C-------------------------------------------------------------
C
C     Copyright by Steven Hayward et.al 2006.
C     DynDom 3D window Version 
C
C-------------------------------------------------------------
C
